<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'category';

    protected $fillable = [
        'title', 'discipline', 'parent', 'status', 'created_by', 'deleted_at', 'deleted_by', 'updated_by'
    ];
//
//    protected $appends = ['lec_count'];

    public function children(){
        return $this->hasMany(Category::class,'parent','id')->select('id','title','parent')->with('children')->where(['deleted' => 0, 'status' => 1]);
    }

    public function lecture(){
        return $this->hasMany(Lecture::class,'category','id');
    }

    public function parent_category(){
        return $this->belongsTo(Category::class,'parent','id')->select('id','title','parent','discipline');
    }

    public function discipline_category(){
        return $this->belongsTo(Discipline::class,'discipline','id')->select('id','title');
    }

//    public function getLecCountAttribute()
//    {
//        $children = $this->children()->pluck('id')->toArray();
//        foreach($children as $child){
//            $child_cat = Category::with('children')->find($child);
//            if($child_cat){
//                $append_child = $this->getChildLecCount($child_cat);
//                $children = array_merge($children, $append_child);
//            }
//        }
//        $children[] = $this->attributes['id'];
//        $total = Lecture::whereIn('category', $children)->where([ 'status' => 1])->count();
//        return 0;
//    }
//    public function getChildLecCount($category){
//        $children = $category->children()->pluck('id')->toArray();
//        foreach($children as $child){
//            $child_cat = Category::with('children')->find($child);
//            if($child_cat){
//                $append_child = $this->getChildLecCount($child_cat);
//                $children = array_merge($children, $append_child);
//            }
//        }
//        return $children;
//    }
}
