<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Area;
use App\Jobs;
use Str;

class AreaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $area = Area::get();
        return view('admin.area.index',compact('area'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.area.form');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'area_name' => 'required|unique:area,area_name'
        ]);
        $data = $request->except('_token');
        $data['slug'] = Str::slug($request->area_name, '-');
        $data['status'] = '0';
        Area::create($data);
        return redirect()->to(route('area.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = Area::find($id);
        return view('admin.area.form',compact('row'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate(['area_name' =>'required']);
        $row = Area::find($id);
        $row->area_name = $request->area_name;
        $row->slug = Str::slug($request->area_name, '-');
        $row->save();
        return redirect()->to(route('area.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $area_jobs = Jobs::where('area_id',$id)->get();
        if ($area_jobs->count() > 0) {
            return redirect()->back()->with('error','Please Delete Jobs first against this Area.');
        }
        $area = Area::find($id);
        $area->delete();
        return redirect()->to(route('area.index'));
    }

    public function status(Request $request,$id)
    {
        if ($request->ajax()) {
            $row = Area::find($id);
            $newStatus = ($row->status == '0') ? '1' : '0';
            $row->update([ 'status' => $newStatus ]);
            return $newStatus;
        }
        return redirect()->back();
    }
}
