<?php

namespace App\Http\Controllers\Admin;

use App\Category;
use App\Discipline;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Str;
use Auth;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = Category::select('id', 'title', 'parent', 'discipline','status')->with(['parent_category', 'discipline_category'])
            ->when(request('title'), function ($query) {
                $searchTitle = request()->get('title');
                $query->where('title', 'LIKE', "%$searchTitle%");
            })
            ->when(request('discipline'), function ($query) {
                $query->where('discipline', request()->get('discipline'));
            })
            ->when(request('parent'), function ($query) {
                $searchTitle = request()->get('parent');
                $query->where('title', 'LIKE', "%$searchTitle%");
            })
            ->where('deleted', 0)->orderBy('id', 'DESC')->paginate(10);
        $disciplines = Discipline::select('id', 'title')->where(['status' => 1,'deleted'=> 0])->get();
        return view('admin.category.index', compact('results', 'disciplines'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $parents = Category::select('id', 'title')->where(['status' => 1,'deleted'=> 0])->get();
        $disciplines = Discipline::select('id', 'title')->where(['status' => 1,'deleted'=> 0])->get();
        return view('admin.category.form', compact('parents', 'disciplines'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|unique:category',
        ]);
//        dd($request);
        $data = $request->except('_token');
//        dd($data);
        $data['created_by'] = Auth::id();
        $data['updated_by'] = Auth::id();
        $data['status'] = '1';
        Category::create($data);
        return redirect()->to(route('course.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = Category::findorFail($id);
        $parents = Category::select('id', 'title')->where(['status' => 1,'deleted'=> 0])->get();
        $disciplines = Discipline::select('id', 'title')->where(['status' => 1,'deleted'=> 0])->get();
        return view('admin.category.form', compact('row', 'parents', 'disciplines'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate(['title' => 'required']);
        $row = Category::find($id);
        $data = $request->all();
        $data['updated_by'] = Auth::id();
        $row->update($data);
        return redirect()->to(route('course.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = Category::find($id);
            $row->deleted = 1;
            $row->deleted_at = Carbon::now();
            $row->deleted_by = Auth::id();
            $row->save();
            return 'true';
        }
        return redirect()->back();
    }

    public function status(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = Category::find($id);
            $newStatus = ($row->status == '0') ? '1' : '0';
            $row->update(['status' => $newStatus]);
            return $newStatus;
        }
        return redirect()->back();
    }

    public function activeAllStatus(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Category::find($value);
                $row->status = 1;
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }

    public function deactiveAllStatus(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Category::find($value);
                $row->status = 0;
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }

    public function deleteAll(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Category::find($value);
                $row->deleted = 1;
                $row->deleted_at = Carbon::now();
                $row->deleted_by = Auth::id();
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }
}
