<?php

namespace App\Http\Controllers\Admin;

use App\Applications;
use App\Banners;
use App\ContactUs;
use App\Jobs;
use App\PageDetails;
use App\Pages;
use App\Settings;
use App\Subscribers;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use App\Types;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use MongoDB\Driver\Monitoring\Subscriber;
use File;

class HomeController extends Controller
{
    public function index()
    {
//        $jobs = Jobs::count();
        $total_banner = Banners::count();
        $total_contact = ContactUs::count();
//        $latest_jobs = Jobs::with('user')->latest('id')->limit(7)->get();
        $users = User::count();
        $categories = Types::count();
        return view('admin.index', compact( 'users', 'categories', 'total_contact', 'total_banner'));
    }

    public function contact_us()
    {
        $contacts = ContactUs::get();
        return view('admin.contact_us', compact('contacts'));
    }

    public function subscribers()
    {
        $subs = Subscribers::get();
        return view('admin.subscribers', compact('subs'));
    }

    public function applications()
    {
        $applications = Applications::with('job')->get();
        return view('admin.applications', compact('applications'));
    }

    public function application_status($id)
    {
        if (request()->ajax()) {
            $model = Applications::find($id);
            if ($model->status === 'Pending')
                $model->status = 'Processing';
            elseif ($model->status === 'Processing')
                $model->status = 'Completed';
            else
                $model->status = 'Pending';
            $model->save();
            return $model->status;
        }
        return redirect()->back();
    }

    public function contact_status($id)
    {
        if (request()->ajax()) {
            $model = ContactUs::find($id);
            if ($model->status === 'Pending')
                $model->status = 'Processing';
            elseif ($model->status === 'Processing')
                $model->status = 'Completed';
            else
                $model->status = 'Pending';
            $model->save();
            return $model->status;
        }
        return redirect()->back();
    }

    public function download_doc(Request $request)
    {
        $path = public_path('/uploads' . $request->doc);
        $new_path = str_replace('cms/public', 'public_html', $path);
        if (!File::exists($new_path)) {
            abort(404);
        }
        return response()->download($new_path);
    }

    public function settings()
    {
        $row = Settings::first();
        return view('admin.settings', compact('row'));
    }

    public function setting_store(Request $request)
    {
        $data = $request->all();
        $save = Settings::updateOrCreate(['user_id' => 1], $data);
        return redirect()->back()->with(['success' => 'Settings Saved']);
    }
}
