<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Institute;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Str;
use Auth;
use File;

class InstituteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = Institute::select('id', 'title','image','status','show_on_front')->where('deleted', 0)->orderBy('id', 'DESC')->get();
        return view('admin.institute.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|unique:institute',
        ]);
        $fileName = null;
        if (request()->hasFile('image')) {
            $file = request()->file('image');
            $fileName = '/institutes/' . md5($file->getClientOriginalName()) . time() . "." . $file->getClientOriginalExtension();
            $file->move('./uploads/institutes', $fileName);
        }
        $data = $request->except('_token');
        $data['created_by'] = Auth::id();
        $data['updated_by'] = Auth::id();
        $data['image'] = $fileName;
        $data['status'] = '1';
        Institute::create($data);
        return redirect()->to(route('institute.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = Institute::findorFail($id);
        $results = Institute::select('id', 'title','image','status')->where('deleted', 0)->orderBy('id', 'DESC')->get();
        return view('admin.institute.index', compact('row', 'results'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate(['title' => 'required']);
        $fileName = null;
        $row = Institute::find($id);
        $currentImage = $row->image;
        if (request()->hasFile('image')) {
            $file = request()->file('image');
            $fileName = '/institutes/' . md5($file->getClientOriginalName()) . time() . "." . $file->getClientOriginalExtension();
            $file->move('./uploads/institutes', $fileName);
        }
        $data = $request->all();
        $data['updated_by'] = Auth::id();
        $data['image'] = ($fileName) ? $fileName : $currentImage;
        $row->update($data);
        if ($fileName)
            File::delete('./uploads' . $currentImage);
        return redirect()->to(route('institute.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = Institute::find($id);
            $row->deleted = 1;
            $row->deleted_at = Carbon::now();
            $row->deleted_by = Auth::id();
            $row->save();
            return 'true';
        }
        return redirect()->back();
    }

    public function status(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = Institute::find($id);
            $newStatus = ($row->status == '0') ? '1' : '0';
            $row->update(['status' => $newStatus]);
            return $newStatus;
        }
        return redirect()->back();
    }

    public function show_on_front(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = Institute::find($id);
            $newStatus = ($row->show_on_front == '0') ? '1' : '0';
            $row->update(['show_on_front' => $newStatus]);
            return $newStatus;
        }
        return redirect()->back();
    }

    public function activeAllStatus(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Institute::find($value);
                $row->status = 1;
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }

    public function deactiveAllStatus(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Institute::find($value);
                $row->status = 0;
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }

    public function deleteAll(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Institute::find($value);
                $row->deleted = 1;
                $row->deleted_at = Carbon::now();
                $row->deleted_by = Auth::id();
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }
}
