<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Level;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Str;
use Auth;

class LevelController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = Level::select('id', 'title', 'status')->where('deleted', 0)->orderBy('id', 'DESC')->get();
        return view('admin.level.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|unique:level',
        ]);
        $data = $request->except('_token');
        $data['created_by'] = Auth::id();
        $data['updated_by'] = Auth::id();
        $data['status'] = '1';
        Level::create($data);
        return redirect()->to(route('level.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = Level::findorFail($id);
        $results = Level::select('id', 'title')->where('deleted', 0)->orderBy('id', 'DESC')->get();
        return view('admin.level.index', compact('row', 'results'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
        ]);
        $row = Level::find($id);
        $data = $request->all();
        $data['updated_by'] = Auth::id();
        $row->update($data);
        return redirect()->to(route('level.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = Level::find($id);
            $row->deleted = 1;
            $row->deleted_at = Carbon::now();
            $row->deleted_by = Auth::id();
            $row->save();
            return 'true';
        }
        return redirect()->back();
    }

    public function status(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = Level::find($id);
            $newStatus = ($row->status == '0') ? '1' : '0';
            $row->update(['status' => $newStatus]);
            return $newStatus;
        }
        return redirect()->back();
    }

    public function activeAllStatus(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Level::find($value);
                $row->status = 1;
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }

    public function deactiveAllStatus(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Level::find($value);
                $row->status = 0;
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }

    public function deleteAll(Request $request)
    {
        if ($request->ajax()) {
            foreach ($request->selectAll as $key => $value) {
                $row = Level::find($value);
                $row->deleted = 1;
                $row->deleted_at = Carbon::now();
                $row->deleted_by = Auth::id();
                $row->save();
            }
            return 'true';
        }
        return redirect()->back();
    }
}
