<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Types;
use App\Jobs;
use Str;

class TypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $types = Types::get();
        return view('admin.type.index',compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.type.form');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|unique:types,title'
        ]);
        $data = $request->except('_token');
        $data['slug'] = Str::slug($request->title, '-');
        $data['status'] = '0';
        Types::create($data);
        return redirect()->to(route('types.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = Types::find($id);
        return view('admin.type.form',compact('row'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate(['title' =>'required']);
        $row = Types::find($id);
        $row->update($request->except('_token'));
        return redirect()->to(route('types.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $type_jobs = Jobs::where('type_id',$id)->get();
        if ($type_jobs->count() > 0) {
            return redirect()->back()->with('error','Please Delete Jobs first against this Type.');
        }
        $type = Types::find($id);
        $type->delete();
        return redirect()->to(route('types.index'));
    }

    public function status(Request $request, $id)
    {
        if ($request->ajax()) {
            $type = Types::find($id);
            $newStatus = ($type->status == '0') ? '1' : '0';
            $type->update([ 'status' => $newStatus ]);
            return $newStatus;
        }
        return redirect()->back();
    }
}
