<?php

namespace App\Http\Controllers;

use App\AgentRegister;
use App\Applications;
use App\Area;
use App\Banners;
use App\Category;
use App\Cities;
use App\ContactUs;
use App\Countries;
use App\Discipline;
use App\Institute;
use App\JobRoles;
use App\Jobs;
use App\Lecture;
use App\Level;
use App\Pages;
use App\Projects;
use App\News;
use App\ProjectsGallery;
use App\Settings;
use App\Interest;
use App\Skills;
use App\Specialties;
use App\Subscribers;
use App\Types;
use Illuminate\Http\Request;
use http\Client\Response;
use PDF;
use DB;
use function Couchbase\defaultDecoder;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
//    public function __construct()
//    {
//        $this->middleware('auth');
//    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $total_courses = Lecture::where(['deleted' => 0, 'status' => 1])->count();
        $settings = Settings::first();
        $pages = Pages::with('page_details')->whereNull('slug')->first();
        $news = News::where(['status' => 1, 'deleted' => 0])->latest('id')->get();
        $institutes = Institute::select('id', 'title', 'image', 'show_on_front')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::with('disc', 'disc.children')
            ->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        foreach ($disciplines as $key => $row) {
            $row->count = Lecture::where('discipline', $row->id)->where(['deleted' => 0, 'status' => 1])->count();
            foreach ($row->disc as $course) {
                $id = [];
                $children = $course->children;
                foreach ($children as $child) {
                    $id[] = $child->id;
                    $append_child = $this->getChildLecCount($child);
                    $id = array_merge($id, $append_child);
                }
                $id[] = $course->id;
                $course->count = Lecture::whereIn('category', $id)->where(['deleted' => 0, 'status' => 1, 'discipline' => $row->id ])->count();
            }
        }
        return view('index', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'total_courses', 'news'));
    }

    public function getChildLecCount($category)
    {
        $children = $category->children;
        $id = [];
        foreach ($children as $child) {
            $id[] = $child->id;
            $append_child = $this->getChildLecCount($child);
            $id = array_merge($id, $append_child);
        }
        return $id;
    }

    public function contact_us(Request $request)
    {
        $request->validate([
            'first_name' => 'required',
            'email' => 'required',
            'phone' => 'required',
//             'message' => 'required',
        ]);
        ContactUs::create($request->all());
        return 'true';
    }

    public function getDownload()
    {
        //PDF file is stored under project/public/download/info.pdf
        $file = public_path() . "/assets/frontend/hmr_brochure.pdf";
        $headers = array(
            'Content-Type: application/pdf',
        );
        return Response::download($file, 'filename.pdf', $headers);
    }

    public function aboutUs()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'about-us')->first();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('about_us', compact('settings', 'banners', 'pages'));
    }

    public function creditors()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'creditors')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('creditors', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'));
    }

    public function mentorship()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'mentorship')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('mentorship', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'));
    }

    public function faqs()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'faqs')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('faqs', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'));
    }

    public function our_projects()
    {
        $settings = Settings::first();
        $projects = Projects::where('status', '1')->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('our_projects', compact('settings', 'banners', 'projects'));
    }

    public function single_project($slug)
    {
        $projects = Projects::where('status', '1')->get();
        $project = Projects::with(['projects_comparision', 'projects_gallery'])->where(['status' => '1', 'slug' => $slug])->first();
        $settings = Settings::first();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('single_project', compact('settings', 'banners', 'project', 'projects'));
    }

    public function services()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('services', compact('settings', 'banners', 'pages'));
    }

    public function contactPage()
    {
        $settings = Settings::first();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        $scroll = false;
        $option = null;
        if (request('scroll')) {
            $scroll = true;
        }
        if (request('option')) {
            $option = request('option');
        }
        return view('contact', compact(['settings', 'scroll', 'option', 'banners']));
    }

    public function saveContactSubmit(Request $request)
    {
        $request->validate([
            'first_name' => 'required',
            'email' => 'email',
            'phone' => 'required',
        ]);
        ContactUs::create($request->all());
        return 'true';
    }

    public function course($id)
    {
        $chars = [' ', '.', ',', '&nbsp;'];
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'course')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::with('disc')->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $courses = Category::select('id', 'title', 'discipline')->with('children')
            ->where(['parent' => $id, 'deleted' => 0, 'status' => 1, 'title' => DB::raw("REPLACE(title, ' ', '')")])
            ->where('title', DB::raw("TRIM(title)"))->orderBy('title')->paginate(25);
        $row = Category::with('discipline_category')->where(['deleted' => 0, 'status' => 1])->findOrFail($id);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('course', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'row', 'courses'));
    }

    public function courseRedirect(Request $request)
    {
        if ($request->parent){
            return redirect()->to('/course_categories/'.$request->parent,301);
        }
    }

    public function discipline($id)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'discipline')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $courses = Category::select('id', 'title', 'discipline')->with('children')->where(['parent' => 0, 'deleted' => 0, 'status' => 1, 'discipline' => $id])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('discipline', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'courses'));
    }

    public function lecture($id)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'lectures')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $row = Category::with('parent_category.discipline_category', 'parent_category.parent_category', 'parent_category.parent_category.discipline_category')->findOrFail($id);
        $lectures = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])->where(['category' => $id, 'deleted' => 0, 'status' => 1])->orderBy('title')->paginate(25);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('lecture', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'row', 'lectures'));
    }

    public function singleLecture($id)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'lecture')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::with('disc')->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $row = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])
            ->where(['deleted' => 0, 'status' => 1])->findOrFail($id);
        $category = Category::with('parent_category.discipline_category', 'parent_category.parent_category.discipline_category')->findOrFail($row->category);
        $categorys = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])->where(['category' => $row->category, 'deleted' => 0, 'status' => 1])->where('id', '!=', $id)->paginate(25);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('single_lecture', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'row', 'categorys', 'category'));
    }

    public function singleLectureRedirect(Request $request)
    {
        if ($request->id){
            return redirect()->to('/single-lecture/'.$request->id,301);
        }
    }

    public function search(Request $request)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'search')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('sort')->get();
        $disciplines = Discipline::with('disc')->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        if ($request->level != 0 || $request->institute != 0 || !empty($request->title)) {
            if ($request->type == 'lectures') {
                $lectures = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])
                    ->when(request('title'), function ($query) {
                        $searchTitle = request()->get('title');
                        $query->where('title', 'LIKE', "%$searchTitle%")
                        ->orWhereHas('lectureCategory', function ($sub_query){
                            $sub_query->where('title', 'LIKE', "%". request()->get('title') ."%");
                        });
                    })
                    ->when(request('discipline'), function ($query) {
                        $query->where('discipline', request()->get('discipline'));
                    })
                    ->when(request('type'), function ($query) {
                        $query->whereHas('lectureCategory', function ($sub_query) {
                            $sub_query->where('title', 'LIKE', "%" . request('category') . "%");
                        });
                    })
                    ->when(request('institute'), function ($query) {
                        $query->where('institute', request()->get('institute'));
                    })
                    ->when(request('level'), function ($query) {
                        $query->where('level', request()->get('level'));
                    })
                    ->where(['deleted' => 0, 'status' => 1])->paginate(25)->withQueryString();
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'lectures'));
            }
            if ($request->type == 'courses') {
                $courses = Category::with('lecture')
                    ->when(request('discipline'), function ($sub_query) {
                        $sub_query->where('discipline', request()->get('discipline'));
                    })
                    ->when(request('title'), function ($query) {
                        $query->where('title', 'LIKE', "%" . request('title') . "%");
                    })
                    ->whereHas('lecture', function ($query){
                        $query->when(request('institute'), function ($sub_query) {
                            $sub_query->where('institute', request()->get('institute'));
                        })->when(request('level'), function ($sub_query) {
                            $sub_query->where('level', request()->get('level'));
                        });
                    })
                    ->where(['deleted' => 0, 'status' => 1])->paginate(25)->withQueryString();
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'courses'));
            }
        } elseif ($request->discipline != 0) {
            if ($request->type == 'courses') {
                $discip = Discipline::with('disc.children')
                    ->where(['deleted' => 0, 'status' => 1, 'id' => $request->discipline])->first();
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'discip'));
            } else {
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'))->with('message', 'please select one field to search!');
            }
        } else {
            return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'))->with('message', 'please select one field to search!');
        }
    }

    public function getCity($id)
    {
        return Cities::where('country_id', $id)->get();
    }

    public function recent_courses($slug)
    {
        $recent_courses = Banner_::where('slug', $slug)->first();
        dd($recent_courses);
    }
}
