<?php

namespace App\Imports;

use App\Category;
use App\Discipline;
use App\Institute;
use App\Instructor;
use App\Lecture;
use App\Level;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Str;
use Validator;

class LectureImport implements ToModel, WithHeadingRow
{
    use Importable;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        if(!empty($row['instructor'])) {
            $instructor = Instructor::Select('id')->where('title', $row['instructor'])->first();
            if (isset($instructor)) {
                $instructor_id = $instructor->id;
            } else {
                $data['title'] = $row['instructor'];
                $data['created_by'] = Auth::id();
                $data['updated_by'] = Auth::id();
                $data['status'] = '1';
                $instructor = Instructor::create($data);
                $instructor_id = $instructor->id;
            }
        }
        if(!empty($row['discipline'])) {
            $discipline = Discipline::Select('id')->where('title', $row['discipline'])->first();
            if (isset($discipline)) {
                $discipline_id = $discipline->id;
            } else {
                $data['title'] = $row['discipline'];
                $data['created_by'] = Auth::id();
                $data['updated_by'] = Auth::id();
                $data['status'] = '1';
                $discipline = Discipline::create($data);
                $discipline_id = $discipline->id;
            }
        }
        $course_id = $this->getCategoryId($row,1,$discipline_id,0);
        if(!empty($row['institute'])) {
            $institute = Institute::Select('id')->where('title', $row['institute'])->first();
            if (isset($institute)) {
                $institute_id = $institute->id;
            } else {
                $data['title'] = $row['institute'];
                $data['created_by'] = Auth::id();
                $data['updated_by'] = Auth::id();
                $data['status'] = '1';
                $institute = Institute::create($data);
                $institute_id = $institute->id;
            }
        }
        if(!empty($row['level'])){
            $level = Level::Select('id')->where('title',$row['level'])->first();
            if (isset($level)){
                $level_id = $level->id;
            }else{
                $data['title'] = $row['level'];
                $data['created_by'] = Auth::id();
                $data['updated_by'] = Auth::id();
                $data['status'] = '1';
                $level = Level::create($data);
                $level_id = $level->id;
            }
        }

        return new Lecture([
            'title' => $row['lecture_title'],
            'instructor' => $instructor_id ?? '',
            'category' => $course_id ?? '',
            'discipline' => $discipline_id ?? '',
            'institute' => $institute_id ?? '',
            'level' => $level_id ?? '',
            'course_number' => $row['course_code'],
            'course_video_link' => $row['video_link'],
            'extension' => $row['extension'],
            'keywords' => $row['keywords'],
            'course_content' => isset($row['course_content']) ? $row['course_content'] : '',
            'created_by' => Auth::id(),
            'updated_by' => Auth::id(),
        ]);

    }

    public function getCategoryId($row,$category_count,$discipline_id,$parent){
        $title = $row['category_'.$category_count];
        $category = Category::Select('id')->where('title',$title)->first();
        if (!empty($category)){
            $category_id = $category->id;
        }else{
            $category = new Category();
            $category->title =
            $category->title = $row['category_'.$category_count];
            $category->discipline = $discipline_id;
            $category->created_by = Auth::id();
            $category->updated_by = Auth::id();
            $category->status = '1';
            if($category_count > 1){
                $category->parent = $parent;
            }
            $category->save();
            $category_id =  $category->id;
        }
        if($row['category_'.($category_count+1)] != null && $category_count < 10){
            $category_id = $this->getCategoryId($row,$category_count+1,$discipline_id,$category->id);
        }
        return $category_id;
    }
}
