<?php

namespace App\Providers;

use App\Pages;
use App\Banners;
use App\Settings;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ViewComposerProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        View::composer('errors/404', function ($view) {
            $view->with([
                'settings' => Settings::first(),
                'pages' => null,
                'banners' => Banners::with(['banner_details' => function ($q) {
                    $q->orderBy('sort');
                }])->get(),
            ]);
        });
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
    }
}
