@extends('admin.layout.master')

@section('title','Job Areas')
@section('main_section')
    <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="row">
                                        <div class="col col-10">
                                            <h4 class="mt-0 mb-3 header-title">Job Area's List</h4>
                                        </div>
                                        <div class="col col-2">
                                            <a href="{{ route('area.create') }}" style="float: right;" class="btn btn-info waves-effect waves-light btn-sm"><i class="fa fa-plus"></i> <span>Create Job Area</span></a>
                                        </div>
                                    </div>

                                    <table id="datatable" class="table table-bordered dt-responsive nowrap">
                                        <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Name</th>
                                            <th>Slug</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($area as $row)
                                            <tr>
                                                <td>{{ $row->id }}</td>
                                                <td>{{ $row->area_name }}</td>
                                                <td>{{ $row->slug }}</td>
                                                <td>
                                                    @if($row->status == '0')
                                                        <a href="{{ route('area.status',$row->id) }}" class="SingleStatus"> <span class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span></a>
                                                    @else
                                                        <a href="{{ route('area.status',$row->id) }}" class="SingleStatus"><span class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span></a>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('area.destroy',$row->id) }}"><i class="fa fa-trash text-danger mr-2"></i></a>
                                                    <a href="{{ route('area.edit',$row->id) }}"><i class="fa fa-edit text-info"></i></a>
                                                </td>
                                                {{-- <td>
                                                    <a href="#" onclick="event.preventDefault(); document.getElementById('delete-form').submit();"><i class="fa fa-trash text-danger mr-2"></i></a>
                                                    <form id="delete-form" class="d-none" action="{{ route('area.destroy',$row->id) }}" method="post">
                                                        @csrf
                                                        @method('delete')
                                                    </form>
                                                    <a href="{{ route('area.edit',$row->id) }}"><i class="fa fa-edit text-info"></i></a>
                                                </td> --}}
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div> <!-- end row -->
                 </div> <!-- container -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" />
    {{-- <link href="/assets/libs/datatables/buttons.bootstrap4.css" rel="stylesheet" type="text/css" /> --}}
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css" />
@stop
@section('script')
    <script src="/assets/js/pages/datatables.init.js"></script>
    {{-- <script src="/assets/js/vendor.min.js"></script> --}}
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
@endsection
