@extends('admin.layout.master')

@section('title',isset($row->id) ? $page_title =  'Edit Projects Comparision' : $page_title =  'Create Projects Comparision')
@section('main_section')
<div class="content-page">
    <div class="content">
        @php
        $action = isset($row->id) ? route('projects_comparision.update',$row->id) : route('projects_comparision.store');
        @endphp
        <!-- Start Content-->
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card-box">
                        <h4 class="m-t-0 header-title">{{ $page_title }}</h4>
                        <div class="row">
                            <div class="col-12">
                                <div class="p-2">
                                    <form class="form-horizontal" role="form" action="{{ $action }}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        @isset($row->id)
                                          @method('put')
                                        @endisset
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="title">Project ID</label>
                                            <input type="hidden" name="project_id" value="{{ $project->id }}">
                                            <div class="col-sm-10">{{ $project->id }}</div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="title">Project Title</label>
                                            <div class="col-sm-10">{{ $project->title }}</div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-form-label col-sm-2">Before Image</label>
                                            <div class="col-sm-10">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input @error('before_image') ? is-invalid @enderror" name="before_image" id="image_field">
                                                    <label class="custom-file-label" for="inputGroupFile01">{{ isset($row->before_image) ? $row->before_image : 'Choose file' }}</label>
                                                    @error('before_image')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label col-sm-2">After Image</label>
                                            <div class="col-sm-10">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input @error('after_image') ? is-invalid @enderror" name="after_image" id="image_field">
                                                    <label class="custom-file-label" for="inputGroupFile01">{{ isset($row->after_image) ? $row->after_image : 'Choose file' }}</label>
                                                    @error('after_image')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        @isset($project_galleries)
                                        <h4 class="m-t-0 header-title">Create Project Gallery</h4>
                                        <div class="form-group row">
                                            <label class="col-form-label col-sm-2">Gallery Image</label>
                                            <div class="col-sm-10">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input @error('gallery_img') ? is-invalid @enderror" name="gallery_img[]" id="image_field" multiple>
                                                    <label class="custom-file-label" for="inputGroupFile01">{{ isset($row->gallery_img) ? $row->gallery_img : 'Choose file' }}</label>
                                                    @error('gallery_img')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        @endisset
                                        <hr>
                                        <div class="row">
                                            <div class="col col-10"></div>
                                            <div class="col col-2">
                                                <button type="submit" class="btn btn-primary">Save</button>
                                                <a href="{{ route('projects.index') }}" class="btn btn-danger">Back</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>
                        <!-- end row -->

                    </div> <!-- end card-box -->
                </div><!-- end col -->
            </div>
            <!-- end row -->
        </div> <!-- container-fluid -->

    </div> <!-- content -->
</div>
@endsection
@section('style')
{{--    <link href="/assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css" />--}}
{{--    <link href="/assets/libs/multiselect/multi-select.css"  rel="stylesheet" type="text/css" />--}}
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
{{--<script src="/assets/libs/multiselect/jquery.multi-select.js"></script>--}}
{{--<script src="/assets/libs/select2/select2.min.js"></script>--}}


<script>
    $(document).ready(function() {
        $("#skill_multi").select2();
        $('#summernote').summernote({
            tabsize: 2,
            height: 150,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ]
        });
    });
</script>
@endsection
