@extends('admin.layout.master')

@section('title','Edit Image')
@section('main_section')
     <div class="content-page">
                <div class="content">
                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-8">
                                <div class="card-box">
                                    <div class="row">
                                        <h4 class="m-t-0 header-title col-md-8">Edit Image</h4>
                                        <a href="{{ route('gallery.destroy',$row->id) }}" class="text-danger text-right col-md-4">Delete Permanently</a>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="p-2">
                                                <form class="form-horizontal" role="form" action="{{ route('gallery.update',$row->id) }}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('put')
                                                    <div class="row mb-5">
                                                        <div class="col-12">
                                                            <div class="row">
                                                                <div class="col-md-2">
                                                                    <strong class="text-dark">File Name:</strong>
                                                                </div>
                                                                <div class="col-md-8">
                                                                    <span>{{$row->file_name}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-2">
                                                                    <strong class="text-dark">File Type:</strong>
                                                                </div>
                                                                <div class="col-md-8">
                                                                    <span>{{$row->type}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-2 pr-0">
                                                                    <strong class="text-dark">Uploaded On:</strong>
                                                                </div>
                                                                <div class="col-md-8">
                                                                    <span>{{date_format($row->created_at,'M d, Y')}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-2">
                                                                    <strong class="text-dark">File Size:</strong>
                                                                </div>
                                                                <div class="col-md-8">
                                                                    <span class="text-uppercase">{{$row->size}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-2">
                                                                    <strong class="text-dark">Dimensions:</strong>
                                                                </div>
                                                                <div class="col-md-8">
                                                                    <span class="text-uppercase">{{$row->dimensions}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-2 pr-0">
                                                                    <strong class="text-dark">Uploaded By:</strong>
                                                                </div>
                                                                <div class="col-md-8">
                                                                    <span class="text-capitalize">{{$row->user->name}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-2">
                                                                    <strong class="text-dark">Link:</strong>
                                                                </div>
                                                                <div class="col-md-9">
                                                                    <span id="link">{{$row->link}}</span>
{{--                                                                    <input type="hidden" value="{{$row->link}}" id="myInput">--}}
                                                                </div>
{{--                                                                <div class="col-md-1 tooltip">--}}
{{--                                                                    <a href="#" onclick="copyToClipboard('#link')" onmouseout="outFunc()" class="btn btn-blue" type="button">--}}
{{--                                                                        <span class="tooltiptext" id="myTooltip">Copy to clipboard</span>--}}
{{--                                                                        Copy--}}
{{--                                                                    </a>--}}
{{--                                                                </div>--}}
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="title">Title</label>
                                                        <div class="col-sm-9">
                                                            <input type="text" id="title" placeholder="Title" class="form-control @error('title') ? is-invalid @enderror " name="title" value="{{ isset($row->id) ? $row->title : old('title') }}">
                                                            @error('title')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="alt_text">Alternative Text</label>
                                                        <div class="col-sm-9">
                                                            <input type="text" id="alt_text" placeholder="Alternative Text" class="form-control @error('alt_text') ? is-invalid @enderror " name="alt_text" value="{{ isset($row->id) ? $row->alt_text : old('alt_text') }}">
                                                            @error('alt_text')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="description">Description</label>
                                                        <div class="col-sm-9">
                                                            <textarea type="text" class="form-control @error('description') ? is-invalid @enderror " name="description" >{{ isset($row->id) ? $row->description : old('description') }}</textarea>
                                                            @error('description')
                                                            <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
{{--                                                    <div class="form-group row">--}}
{{--                                                        <label class="col-sm-2  col-form-label" for="caption">Caption</label>--}}
{{--                                                        <div class="col-sm-9">--}}
{{--                                                            <textarea type="text" class="form-control @error('caption') ? is-invalid @enderror " name="caption" >{{ isset($row->id) ? $row->caption : old('caption') }}</textarea>--}}
{{--                                                            @error('caption')--}}
{{--                                                            <span class="invalid-feedback" role="alert">--}}
{{--                                                    <strong>{{ $message }}</strong>--}}
{{--                                                </span>--}}
{{--                                                            @enderror--}}
{{--                                                        </div>--}}
{{--                                                    </div>--}}
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col col-8"></div>
                                                        <div class="col col-4">
                                                            <button type="submit" class="btn btn-primary">Save</button>
                                                            <a href="{{ route('gallery.index') }}" class="btn btn-danger">Cancel</a>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                    <!-- end row -->

                                </div> <!-- end card-box -->
                            </div><!-- end col -->
                            <div class="col-4">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title">Image</h4>
                                    <div class="gal-detail thumb mt-0">
                                        <a href="#" class="image-popup">
                                            <img src="{{ $row->link }}" class="thumb-img img-fluid" alt="{{$row->image}}">
                                        </a>
                                    </div>
                                </div>
                                </div>
                        </div>
                        <!-- end row -->
                    </div> <!-- container-fluid -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
    <style>
        .tooltip {
            position: relative;
            display: inline-block;
            opacity: 1 !important;
        }

        .tooltip .tooltiptext {
            visibility: hidden;
            width: 140px;
            background-color: #555;
            color: #fff;
            text-align: center;
            border-radius: 6px;
            padding: 5px;
            position: absolute;
            z-index: 1;
            bottom: 130%;
            left: 50%;
            margin-left: -75px;
            transition: opacity 0.3s;
        }

        .tooltip .tooltiptext::after {
            content: "";
            position: absolute;
            top: 100%;
            left: 50%;
            margin-left: -5px;
            border-width: 5px;
            border-style: solid;
            border-color: #555 transparent transparent transparent;
        }

        .tooltip:hover .tooltiptext {
            visibility: visible;
            opacity: 1;
        }
    </style>
@stop
@section('script')
    <script>
        // function myFunction() {
        //     var copyText = document.getElementById("myInput");
        //     copyText.select();
        //     copyText.setSelectionRange(0, 99999);
        //     document.execCommand("copy");
        //
        //     var tooltip = document.getElementById("myTooltip");
        //     tooltip.innerHTML = "Copied: " + copyText.value;
        // }
        // function copyToClipboard(element) {
        //     var $temp = $("<span>");
        //     $("body").append($temp);
        //     $temp.val($(element).text()).select();
        //     document.execCommand("copy");
        //     $temp.remove();
        // }
        // function outFunc() {
        //     var tooltip = document.getElementById("myTooltip");
        //     tooltip.innerHTML = "Copy to clipboard";
        // }
    </script>
@endsection
