@extends('admin.layout.master')

@section('title',isset($row->id) ? $page_title =  'Edit Projects Gallery' : $page_title =  'Create Projects Gallery')
@section('main_section')
<div class="content-page">
    <div class="content">
        @php
        $action = isset($row->id) ? route('projects_gallery.update',$row->id) : route('projects_gallery.store');
        @endphp
        <!-- Start Content-->
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card-box">
                        <h4 class="m-t-0 header-title">{{ $page_title }}</h4>
                        <div class="row">
                            <div class="col-12">
                                <div class="p-2">
                                    <form class="form-horizontal" role="form" action="{{ $action }}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        @isset($row->id)
                                          @method('put')
                                        @endisset
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="title">Project ID</label>
                                            <input type="hidden" name="project_id" value="{{ $project->id }}">
                                            <div class="col-sm-10">{{ $project->id }}</div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="title">Project Title</label>
                                            <div class="col-sm-10">{{ $project->title }}</div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label col-sm-2">Gallery Image</label>
                                            <div class="col-sm-10">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input @error('gallery_img') ? is-invalid @enderror" name="gallery_img" id="image_field">
                                                    <label class="custom-file-label" for="inputGroupFile01">{{ isset($row->gallery_img) ? $row->gallery_img : 'Choose file' }}</label>
                                                    @error('gallery_img')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col col-10"></div>
                                            <div class="col col-2">
                                                <button type="submit" class="btn btn-primary">Save</button>
                                                <a href="{{ route('projects.index') }}" class="btn btn-danger">Back</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>
                        <!-- end row -->

                    </div> <!-- end card-box -->
                    @if(!isset($row))
                    <div class="card-box">
                        <div class="row">
                            <div class="col col-10">
                                <h4 class="mt-0 mb-3 header-title">Projects Gallery List</h4>
                            </div>
                        </div>
                        @if ($errors->has('error'))
                            <div class="alert alert-danger">{{ $error->error }}</div>
                        @endif
                        <table id="datatable" class="table table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Before Image</th>
                                <th>After Image</th>
                                <th>Created By</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($project_galleries as $project)
                                <tr>
                                    <td>{{$project->id }}</td>
                                    @if ($project->before_image)
                                        <td><img src="/uploads{{ $project->before_image }}" class="mx-auto d-block img-thumbnail" width="200" alt="{{ $project->title }}"></td>
                                    @else
                                        <td class="text-center">No Image</td>
                                    @endif
                                    @if ($project->after_image)
                                        <td><img src="/uploads{{ $project->after_image }}" class="mx-auto d-block img-thumbnail" width="200" alt="{{ $project->title }}"></td>
                                    @else
                                        <td class="text-center">No Image</td>
                                    @endif
                                    <td>{{$project->user->name }}</td>
                                    <td>
                                        @if($project->status == '0')
                                            <a href="{{ route('projects_gallery.status',$project->id) }}" class="SingleStatus"> <span class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span></a>
                                        @else
                                            <a href="{{ route('projects_gallery.status',$project->id) }}" class="SingleStatus"><span class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span></a>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('projects_gallery.destroy',$project->id) }}"><i class="fa fa-trash text-danger mr-2"></i></a>
                                        <a href="{{ route('projects_gallery.edit',$project->id) }}"><i class="fa fa-edit text-info"></i></a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    @endisset
                </div><!-- end col -->
            </div>
            <!-- end row -->
        </div> <!-- container-fluid -->

    </div> <!-- content -->
</div>
@endsection
@section('style')
{{--    <link href="/assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css" />--}}
{{--    <link href="/assets/libs/multiselect/multi-select.css"  rel="stylesheet" type="text/css" />--}}
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
{{--<script src="/assets/libs/multiselect/jquery.multi-select.js"></script>--}}
{{--<script src="/assets/libs/select2/select2.min.js"></script>--}}


<script>
    $(document).ready(function() {
        $("#skill_multi").select2();
        $('#summernote').summernote({
            tabsize: 2,
            height: 150,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ]
        });
    });
</script>
@endsection
