<!DOCTYPE html>
<html lang="en">
<head>
        <meta charset="utf-8" />
        <title>CMS | @yield('title')</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta name="csrf-token" content="{{csrf_token()}}" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="/assets/images/fav-icon.png">

        <!--Morris Chart-->
        <link rel="stylesheet" href="/assets/libs/morris-js/morris.css" />
        <link href="/assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />
        <!-- App css -->
        <link href="/assets/libs/bootstrap-tagsinput/bootstrap-tagsinput.css" rel="stylesheet" />
        <link href="/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <link href="/assets/css/app.min.css" rel="stylesheet" type="text/css" />
        @yield('style')
    </head>

    <body>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <div class="navbar-custom">
                <ul class="list-unstyled topnav-menu float-right mb-0">

                    <li class="dropdown notification-list">
                        <a class="nav-link dropdown-toggle nav-user mr-0 waves-effect" data-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                            <img src="/assets/images/users/user-1.jpg" alt="user-image" class="rounded-circle">
                            <span class="pro-user-name ml-1">
                                {{ auth()->user()->name }} <i class="mdi mdi-chevron-down"></i>
                            </span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right profile-dropdown ">
                            <!-- item-->
                            <div class="dropdown-header noti-title">
                                <h6 class="text-overflow m-0">Welcome !</h6>
                            </div>

                            <!-- item-->
                            <a href="{{ route('profile.edit',auth()->user()->id) }}" class="dropdown-item notify-item">
                                <i class="fe-user"></i>
                                <span>My Account</span>
                            </a>
                            <div class="dropdown-divider"></div>

                            <!-- item-->
                            <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="dropdown-item notify-item">
                                <i class="fe-log-out"></i>
                                <span>Logout</span>
                            </a>
                            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                @csrf
                            </form>

                        </div>
                    </li>




                </ul>

                <!-- LOGO -->
                <div class="logo-box">
                    <a href="#" class="logo text-center">
                        <span class="logo-lg">
                            <img src="/assets/images/logo-dark.png" alt="" height="50">
                            <!-- <span class="logo-lg-text-light">Xeria</span> -->
                        </span>
                        <span class="logo-sm">
                            <!-- <span class="logo-sm-text-dark">X</span> -->
                            <img src="/assets/images/logo-dark.png" alt="" height="24">
                        </span>
                    </a>
                </div>

                <ul class="list-unstyled topnav-menu topnav-menu-left m-0">
                    <li>
                        <button class="button-menu-mobile disable-btn waves-effect">
                            <i class="fe-menu"></i>
                        </button>
                    </li>

                    <li>
                        <h4 class="page-title-main">@yield('title')</h4>
                    </li>

                </ul>
            </div>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <div class="left-side-menu">

                <div class="slimscroll-menu">

                    <!-- User box -->
                    <div class="user-box text-center">
                        <img src="/assets/images/users/user-1.jpg" alt="user-img" title="Mat Helme" class="rounded-circle img-thumbnail avatar-lg">
                        <div class="dropdown">
                            <a href="#" class="text-dark dropdown-toggle h5 mt-2 mb-1 d-block" data-toggle="dropdown">{{ auth()->user()->name }}</a>
                        </div>
                    </div>

                    <!--- Sidemenu -->
                    <div id="sidebar-menu">

                        <ul class="metismenu" id="side-menu">

                            <li class="menu-title">Navigation</li>

                            <li>
                                <a href="{{ route('dashboard') }}">
                                    <i class="mdi mdi-view-dashboard"></i>
                                    <span> Dashboard </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('pages.index') }}">
                                    <i class="mdi mdi-book-open"></i>
                                    <span> Pages </span>
                                </a>
                            </li>
                            <li>
                                <a href="javascript: void(0);">
                                    <i class="fa fa-campground"></i>
                                    <span> Lecture </span>
                                    <span class="menu-arrow"></span>
                                </a>
                                <ul class="nav-second-level" aria-expanded="false">
                                    <li>
                                        <a href="{{ route('lecture.create') }}">
                                            <i class="fa fa-plus"></i>
                                            <span> Add Lecture </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('lecture.index') }}">
                                            <i class="fa fa-campground"></i>
                                            <span> Lecture </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('course.index') }}">
                                            <i class="fas fa-tasks"></i>
                                            <span> Courses </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('discipline.index') }}">
                                            <i class="fas fa-school"></i>
                                            <span> Discipline </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('institute.index') }}">
                                            <i class="fa fa-university"></i>
                                            <span> Institute </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('level.index') }}">
                                            <i class="fa fa-step-forward"></i>
                                            <span> Level </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('instructor.index') }}">
                                            <i class="fas fa-chalkboard-teacher"></i>
                                            <span> Instructor </span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <a href="{{ route('banners.index') }}">
                                    <i class="fa fa-images"></i>
                                    <span> Banners </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('news.index') }}">
                                    <i class="mdi mdi-newspaper"></i>
                                    <span> News </span>
                                </a>
                            </li>
                            <li class="">
                                <a href="{{ route('contact_us') }}">
                                    <i class="mdi mdi-phone"></i>
                                    <span> Contacts </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('settings') }}">
                                    <i class="fa fa-cog"></i>
                                    <span> Settings </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('users.index') }}">
                                    <i class="mdi mdi-account-multiple"></i>
                                    <span> Users </span>
                                </a>
                            </li>


                        </ul>

                    </div>
                    <!-- End Sidebar -->

                    <div class="clearfix"></div>

                </div>
                <!-- Sidebar -left -->

            </div>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            @yield('main_section')
            <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row"></div>
                    </div>
                </footer>
                <!-- end Footer -->
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="/assets/js/vendor.min.js"></script>

        <!-- knob plugin -->
        <script src="/assets/libs/jquery-knob/jquery.knob.min.js"></script>

        <!--Morris Chart-->
        <script src="/assets/libs/morris-js/morris.min.js"></script>
        <script src="/assets/libs/raphael/raphael.min.js"></script>

        <!-- Dashboard init js-->
        <script src="/assets/js/pages/dashboard.init.js"></script>

        <!-- App js -->
        <script src="/assets/js/app.min.js"></script>
{{--        <script src="/assets/libs/sweetalert2/sweetalert2.min.js"></script>--}}
        <script src="/assets/libs/bootstrap-tagsinput/bootstrap-tagsinput.min.js"></script>

        <!-- Sweet alert init js-->
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script src="/assets/js/pages/sweet-alerts.init.js"></script>
        <script src="/assets/js/custom.js"></script>
        <script>
            // $('.fa-trash').on('click',function(e){
            //     if(confirm('Are You Sure ?') != true)
            //         return false;
            // });
        </script>
        @if (count($errors) > 0)
            <script>
                $(document).ready(function() {
                    $('#form_modal').modal('show');
                });
            </script>
        @endif
        @yield('script')
    </body>

<!-- Mirrored from coderthemes.com/adminto/layouts/light/ by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 17 Sep 2019 14:07:36 GMT -->
</html>
