@extends('admin.layout.master')

@section('title',isset($row->id) ? 'Edit Job' :'Create Job')
@section('main_section')
<div class="content-page">
    <div class="content">
        @php
        $action = isset($row->id) ? route('level.update',$row->id) : route('level.store');
        @endphp
        <!-- Start Content-->
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card-box">
                        <h4 class="m-t-0 header-title">Create Job</h4>
                        <div class="row">
                            <div class="col-12">
                                <div class="p-2">
                                    <form class="form-horizontal" role="form" action="{{ $action }}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        @isset($row->id)
                                          @method('put')
                                        @endisset
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="title">Title</label>
                                            <div class="col-sm-10">
                                                <input type="text" id="title" placeholder="Title" class="form-control @error('title') ? is-invalid @enderror " name="title" value="{{ isset($row->id) ? $row->title : old('title') }}">
                                                @error('title')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="job_id">Job Id</label>
                                            <div class="col-sm-10">
                                                <input type="text" id="job_id" placeholder="Job Id" class="form-control @error('job_id') ? is-invalid @enderror " name="job_id" value="{{ isset($row->id) ? $row->job_id : old('job_id') }}">
                                                @error('job_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label" for="skills">Skills</label>
                                            <div class="col-sm-10">
                                                @if(isset($row->skill_id))
                                                    <select class="select2 select2-multiple" id="skill_multi" name="skill_id[]" multiple>
                                                        @foreach($skills as $skill)
                                                            <option value="{{ $skill->id }}" {{ isset($row->skill_id) ? ( isset($skill->id) && in_array($skill->id,$row->skill_id) ? 'selected' : null ) : old('skill_id')}}>{{ $skill->title }}</option>
                                                        @endforeach
                                                    </select>
                                                @else
                                                    <select class="select2 select2-multiple" id="skill_multi" name="skill_id[]" multiple>
                                                        @foreach($skills as $skill)
                                                            <option value="{{ $skill->id }}">{{ $skill->title }}</option>
                                                        @endforeach
                                                    </select>
                                                @endif
                                                @error('skill_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label" for="area_id">Area</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="area_id">
                                                    <option selected>Select Area</option>
                                                    @foreach($area as $ar)
                                                        <option value="{{ $ar->id }}" {{ isset($row->area->id) ? $row->area->id == $ar->id ? 'selected' : null : old('area_id')}}>{{ $ar->area_name }}</option>
                                                    @endforeach
                                                </select>
                                                @error('area')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label" for="specialties_id">Specialties</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="specialties_id">
                                                    <option selected>Select speciality</option>
                                                    @foreach($specialties as $speciality)
                                                        <option value="{{ $speciality->id }}" {{ isset($row->speciality->id) ? $row->speciality->id == $speciality->id ? 'selected' : null : old('specialties_id')}}>{{ $speciality->title }}</option>
                                                    @endforeach
                                                </select>
                                                @error('speciality')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label" for="type_id">Type</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="type_id">
                                                    <option selected>Select Type</option>
                                                    @foreach($types as $type)
                                                    <option value="{{ $type->id }}" {{ isset($row->type->id) ? $row->type->id == $type->id ? 'selected' : null : old('type_id')}}>{{ $type->title }}</option>
                                                    @endforeach
                                                </select>
                                                @error('type_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2 col-form-label" for="role_id">Role</label>
                                            <div class="col-sm-10">
                                                <select class="custom-select" name="role_id">
                                                    <option selected value="">Select Job Role</option>
                                                    @foreach($roles as $role)
                                                        <option value="{{ $role->id }}" {{ isset($row->role->id) ? $row->role->id == $role->id ? 'selected' : null : old('role_id')}}>{{ $role->title }}</option>
                                                    @endforeach
                                                </select>
                                                @error('role_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label col-sm-2">Last Date To Apply</label>
                                            <div class="col-sm-10">
                                                <div class="input-group">
                                                    <input type="date" class="form-control @error('last_date') ? is-invalid @enderror" value="{{ isset($row->last_date) ? $row->last_date : old('last_date') }}" name="last_date" placeholder="mm/dd/yyyy">
                                                    @error('last_date')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                    <div class="input-group-append">
                                                        <span class="input-group-text"><i class="ti-calendar"></i></span>
                                                    </div>
                                                </div><!-- input-group -->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label col-sm-2">Salary</label>
                                            <div class="col-sm-10">
                                                <div class="input-group">
                                                    <input type="text" class="form-control @error('salary') ? is-invalid @enderror" value="{{ isset($row->salary) ? $row->salary : old('salary') }}" name="salary" placeholder="Salary">
                                                    @error('salary')
                                                    <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div><!-- input-group -->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-form-label col-sm-2">Image</label>
                                            <div class="col-sm-10">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input @error('image') ? is-invalid @enderror" name="image" id="image_field">
                                                    <label class="custom-file-label" for="inputGroupFile01">{{ isset($row->image) ? $row->image : 'Choose file' }}</label>
                                                    @error('image')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="description">Short Description</label>
                                            <div class="col-sm-10">
                                                <textarea type="text" class="form-control @error('short_description') ? is-invalid @enderror " name="short_description" >{{ isset($row->id) ? $row->short_description : old('short_description') }}</textarea>
                                                @error('short_description')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-sm-2  col-form-label" for="description">Description</label>
                                            <div class="col-sm-10">
                                                <textarea type="text" id="summernote" class="form-control @error('description') ? is-invalid @enderror " name="description" >{{ isset($row->id) ? $row->description : old('description') }}</textarea>
                                                @error('description')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col col-10"></div>
                                            <div class="col col-2">
                                                <button type="submit" class="btn btn-primary">Save</button>
                                                <a href="{{ route('jobs.index') }}" class="btn btn-danger">Cancel</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>
                        <!-- end row -->

                    </div> <!-- end card-box -->
                </div><!-- end col -->
            </div>
            <!-- end row -->
        </div> <!-- container-fluid -->

    </div> <!-- content -->
</div>
@endsection
@section('style')
{{--    <link href="/assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css" />--}}
{{--    <link href="/assets/libs/multiselect/multi-select.css"  rel="stylesheet" type="text/css" />--}}
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
{{--<script src="/assets/libs/multiselect/jquery.multi-select.js"></script>--}}
{{--<script src="/assets/libs/select2/select2.min.js"></script>--}}


<script>
    $(document).ready(function() {
        $("#skill_multi").select2();
        $('#summernote').summernote({
            tabsize: 2,
            height: 150,
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ]
        });
    });
</script>
@endsection
