@extends('admin.layout.master')

@section('title',isset($row->id) ? 'Edit News' :'Create News')
@section('main_section')
     <div class="content-page">
         <div class="content">
@php
    $count = 1;
    $action = isset($row->id) ? route('news.update',$row->id) : route('news.store');
@endphp
            <!-- Start Content-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="m-t-0 header-title">Create News</h4>
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" role="form" action="{{ $action }}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            @isset($row->id)
                                                @method('put')
                                            @endisset
                                            <div class="form-group row">
                                                <label class="col-sm-2  col-form-label" for="title">Title</label>
                                                <div class="col-sm-9">
                                                    <input type="text" id="title" placeholder="Title" class="form-control @error('title') ? is-invalid @enderror " name="title" value="{{ isset($row->id) ? $row->title : old('title') }}">
                                                    @error('title')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-sm-2  col-form-label" for="title">Link</label>
                                                <div class="col-sm-9">
                                                    <input type="text" id="link" placeholder="Link" class="form-control @error('link') ? is-invalid @enderror " name="link" value="{{ isset($row->id) ? $row->link : old('link') }}">
                                                    @error('link')
                                                    <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2  col-form-label" for="title">Date</label>
                                                <div class="col-md-9">
                                                    <input type="date" id="date" placeholder="Date" class="form-control @error('date') ? is-invalid @enderror " name="date" value="{{ isset($row->id) ? $row->date : old('date') }}">
                                                    @error('date')
                                                    <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-sm-2  col-form-label" for="title">Content</label>
                                                <div class="col-sm-9">
                                                    <textarea id="content" rows="5" placeholder="Content" class="form-control @error('content') ? is-invalid @enderror " name="content">{{ isset($row->id) ? $row->content : old('content') }}</textarea>
                                                    @error('content')
                                                    <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col col-10"></div>
                                                <div class="col col-2">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                    <a href="{{ route('news.index') }}" class="btn btn-danger">Cancel</a>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->

                        </div> <!-- end card-box -->
                    </div><!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->
        </div> <!-- content -->
    </div>
@endsection
@section('style')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.homeData').summernote({
                tabsize: 2,
                height: 120,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
        function deleteRow(i){
            if (confirm("Are You Sure?") === true) {
                $(".form-html-"+i).remove();
            }
        }
    </script>
@endsection
