@extends('admin.layout.master')

@section('title',isset($row->id) ? 'Edit Page' :'Create Page')
@section('main_section')
    <div class="content-page">
        <div class="content">
            @php
                $title = isset($row->id) ? 'Edit' : 'Create';
                $action = isset($row->id) ? route('pages.update',$row->id) : route('pages.store');
            @endphp
                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title">{{$title}} Page</h4>
                                    <div class="row">
                                        <div class="col-12">
                                            @if (\Session::has('success'))
                                                <div class="alert alert-success alert-dismissable">
                                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                    {!! \Session::get('success') !!}
                                                </div>
                                            @endif
                                            <div class="p-2">
                                                <form class="form-horizontal" role="form" action="{{$action}}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    @isset($row->id)
                                                        @method('put')
                                                    @endisset
                                                    @if (isset($row) ? $row->id > 1 : null || $title == 'Create')
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="title">Page Titlee</label>
                                                        <div class="col-sm-9">
                                                            <input type="text" id="title" placeholder="Title" class="form-control @error('title') ? is-invalid @enderror " name="title" value="{{ isset($row->id) ? $row->title : old('title') }}">
                                                            @error('title')
                                                            <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    @endif

                                                    @if (isset($row->page_details))
                                                        @foreach($row->page_details as $key => $detail)
                                                            <div class="form-html-{{$key}}">
                                                            <div class="form-group row">
                                                                <label class="col-sm-2  col-form-label" for="title">Title</label>
                                                                <div class="col-sm-9">
                                                                    <input type="text" id="title" placeholder="Title" class="form-control @error('page_details.'.$key.'.title') ? is-invalid @enderror " name="page_details[{{$key}}][title]" value="{{ isset($detail->id) ? $detail->title : old('page_details.'.$key.'.title') }}">
                                                                    @error('page_details.'.$key.'.title')
                                                                    <span class="invalid-feedback" role="alert">
                                                                        <strong>{{ $message }}</strong>
                                                                    </span>
                                                                    @enderror
                                                                </div>
                                                                <div class="col-sm-1">
                                                                    <button class="btn btn-icon waves-effect waves-light btn-danger" onclick="deleteRow({{$key}})" type="button"> <i class="fas fa-times"></i> </button>
                                                                </div>
                                                            </div>
                                                            <div class="form-group row">
                                                                <label class="col-sm-2  col-form-label" for="template">Editor</label>
                                                                <div class="col-sm-9">
                                                                    <textarea class="form-control homeData @error('page_details.'.$key.'.template') ? is-invalid @enderror " name="page_details[{{$key}}][template]" >{{ isset($detail->id) ? $detail->template : old('page_details.'.$key.'.template') }}</textarea>
                                                                    @error('page_details.'.$key.'.template')
                                                                        <span class="invalid-feedback" role="alert">
                                                                            <strong>{{ $message }}</strong>
                                                                        </span>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                            </div>
                                                        @endforeach
                                                    @else
                                                        <div class="form-group row">
                                                            <label class="col-sm-2  col-form-label" for="title">Title</label>
                                                            <div class="col-sm-9">
                                                                <input type="text" id="title" placeholder="Title" class="form-control @error('page_details.0.title') ? is-invalid @enderror " name="page_details[0][title]" value="{{ old('page_details.0.title') }}">
                                                                @error('page_details.0.title')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                        <div class="form-group row">
                                                            <label class="col-sm-2  col-form-label" for="template">Editor</label>
                                                            <div class="col-sm-9">
                                                                <textarea type="text" class="form-control homeData @error('page_details.0.template') ? is-invalid @enderror " name="page_details[0][template]" >{{ old('page_details.0.template') }}</textarea>
                                                                @error('page_details.0.template')
                                                                <span class="invalid-feedback" role="alert">
                                                                        <strong>{{ $message }}</strong>
                                                                    </span>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    @endif

                                                    <div id="show-more"></div>

                                                    <div class="form-group row">
                                                        <div class="col-sm-11"></div>
                                                        <div class="col-sm-1">
                                                            <button class="btn btn-icon waves-effect waves-light btn-success" id="add-more"> <i class="fas fa-plus"></i> </button>
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="meta_title">Meta Title</label>
                                                        <div class="col-sm-9">
                                                            <input type="text" id="meta_title" placeholder="Meta Title" class="form-control @error('meta_title') ? is-invalid @enderror " name="meta_title" value="{{ isset($row->id) ? $row->meta_title : old('meta_title') }}">
                                                            @error('meta_title')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="meta_keyword">Meta Keyword</label>
                                                        <div class="col-sm-9">
                                                            <input type="text" id="meta_keyword" placeholder="Meta keyword" class="form-control @error('meta_keyword') ? is-invalid @enderror " name="meta_keyword" value="{{ isset($row->id) ? $row->meta_keyword : old('meta_keyword') }}" data-role="tagsinput">
                                                            @error('meta_keyword')
                                                            <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-form-label col-sm-2">Meta Image</label>
                                                        <div class="col-sm-9">
                                                            <div class="custom-file">
                                                                <input type="file" class="custom-file-input @error('meta_image') ? is-invalid @enderror" name="meta_image" id="inputGroupFile01">
                                                                <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                                                                @error('meta_image')
                                                                <span class="invalid-feedback" role="alert">
                                                                        <strong>{{ $message }}</strong>
                                                                    </span>
                                                                @enderror
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if (isset($row->meta_image))
                                                        <div class="form-group row">
                                                            <div class="col-md-2"></div>
                                                            <div class="col-md-6 col-xl-3 col-lg-4 natural personal">
                                                                <div class="gal-detail thumb mt-0">
                                                                    <a href="#" class="image-popup">
                                                                        <img src="/uploads/{{ $row->meta_image }}" class="thumb-img img-fluid" alt="{{$row->meta_title}}">
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="meta_description">Meta Description</label>
                                                        <div class="col-sm-9">
                                                            <textarea type="text" class="form-control  @error('meta_description') ? is-invalid @enderror " name="meta_description" >{{ isset($row->id) ? $row->meta_description : old('meta_description') }}</textarea>
                                                            @error('meta_description')
                                                            <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col col-11"></div>
                                                        <div class="col col-1">
                                                            <button type="submit" class="btn btn-primary">Save</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                    <!-- end row -->

                                </div> <!-- end card-box -->
                            </div><!-- end col -->
                        </div>
                        <!-- end row -->
                    </div> <!-- container-fluid -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.homeData').summernote({
                tabsize: 2,
                height: 250,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
            var count = {{isset($row) ? count($row->page_details)+1 : 1}};

            $("#add-more").on('click',function (e){
                e.preventDefault();
                var datahtml = `<div class="form-html-${count}"><div class="form-group row">
                        <label class="col-sm-2  col-form-label" for="title">Title</label>
                           <div class="col-sm-9">
                              <input type="text" id="title" placeholder="Title" class="form-control @error('title') ? is-invalid @enderror " name="page_details[${count}][title]" value="{{ old('title') }}">
                                                            @error('title')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                                                            </span>
                                                            @enderror
                </div>
                <div class="col-sm-1">
                    <button class="btn btn-icon waves-effect waves-light btn-danger" onclick="deleteRow(${count})" type="button"> <i class="fas fa-times"></i> </button>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-2  col-form-label" for="template">Editor</label>
                <div class="col-sm-9">
                    <textarea type="text" class="form-control homeData @error('template') ? is-invalid @enderror " name="page_details[${count}][template]" >{{ old('template') }}</textarea>
                                                            @error('template')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                </div>
            </div></div>`;
                $("#show-more").append(datahtml);
                $('.homeData').summernote({
                    tabsize: 2,
                    height: 250,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'underline', 'clear']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['table', ['table']],
                        ['view', ['fullscreen', 'codeview', 'help']]
                    ]
                });
                count++
            });
        });
        function deleteRow(i){
            if (confirm("Are You Sure?") === true) {
                $(".form-html-"+i).remove();
            }
        }
    </script>
@endsection
