@extends('admin.layout.master')

@section('title',isset($row->id) ? 'Edit User' :'Create User')
@section('main_section')
     <div class="content-page">
                <div class="content">
                @php
                    $action = isset($row->id) ? route('users.update',$row->id) : route('users.store');   
                @endphp
                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title">Create User</h4>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="p-2">
                                                <form class="form-horizontal" role="form" action="{{ $action }}" method="post">
                                                    @csrf
                                                    @isset($row->id)
                                                        @method('put')
                                                    @endisset
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="name">Name</label>
                                                        <div class="col-sm-10">
                                                            <input type="text" id="name"placeholder="Name" class="form-control @error('name') ? is-invalid @enderror " name="name" value="{{ isset($row->id) ? $row->name : old('name') }}">
                                                            @error('name')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="email">Email</label>
                                                        <div class="col-sm-10">
                                                            <input type="text" id="email"placeholder="Email" class="form-control @error('email') ? is-invalid @enderror " name="email" value="{{ isset($row->id) ? $row->email : old('email') }}">
                                                            @error('email')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2 col-form-label" for="role">Role</label>
                                                        <div class="col-sm-10">
                                                            <select class="custom-select" name="role">
                                                                <option value="admin" {{ isset($row->role) ? $row->role == 'admin' ? 'selected' : null : old('role')}}>Admin</option>
                                                                <option value="user" {{ isset($row->role) ? $row->role == 'user' ? 'selected' : null : old('role')}}>User</option>
                                                            </select>
                                                            @error('role')
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="password">Password</label>
                                                        <div class="col-sm-10">
                                                            <input type="password" id="password"placeholder="Password" class="form-control @error('password') ? is-invalid @enderror " name="password" value="">
                                                            @error('password')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="password_confirmation">Confirm Password</label>
                                                        <div class="col-sm-10">
                                                            <input type="password" id="password_confirmation" placeholder="password_confirmation" class="form-control @error('password_confirmation') ? is-invalid @enderror " name="password_confirmation" value="">
                                                            @error('password_confirmation')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col col-10"></div>
                                                        <div class="col col-2">
                                                            <button type="submit" class="btn btn-primary">Save</button>
                                                            <a href="{{ route('users.index') }}" class="btn btn-danger">Cancel</a>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                    <!-- end row -->

                                </div> <!-- end card-box -->
                            </div><!-- end col -->
                        </div>
                        <!-- end row -->
                    </div> <!-- container-fluid -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
@stop
@section('script')
@endsection