@extends('layout.master')
@section('page_title')
    Search {{ request('type') }}
@endsection
@section('main_content')
    <div class="heightHead"></div>
    <section class="">
        <div class="btnback">
            <div class="xl:container lg:container md:container sm:container mb-4">
                <h1 class="text-2xl font-semibold text-white uppercase text-right xl:px-0 px-4">Search {{ request('type') }}</h1>
            </div>
        </div>
        <div>
            <!-- SEARCH -->
            @include('layout.search')
        </div>
        <div class="container-fluid">
            <div class="xl:container lg:container md:container sm:container xl:px-0 px-4">
                <div class="grid grid-cols-12 xl:my-4 my-6">
                    <div class="col-span-12">
                        <div class="breadcrumb">
                            <ul class="inline-block text-xs">
                                <li class="inline-block"><a href="/">Home</a></li>
                                @if(request('type') == 'courses' && isset($discip))
                                    <li class="px-1 inline-block"> >></li>
                                    <li class="inline-block"><a href="/search?title=&type=courses&discipline={{ $discip->id }}&level=0&institute=0">{{ $discip->title }}</a></li>
                                @else
                                    <li class="px-1 inline-block"> >></li>
                                    <li class="inline-block">search</li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="xl:container lg:container md:container sm:container">
                <div class="grid grid-cols-12 gap-6 xl:my-12 lg:my-8 my-6 xl:px-0 px-4">
                    <div class="xl:col-span-9 lg:col-span-9 col-span-12">
                        @if(isset($message))
                            <div class="text-green-400 bg-green-200 py-2 px-6 text-center">
                                {{ $message }}
                            </div>
                        @endif
                        @if(request('level') != 0 || request('institute') != 0 || !empty(request('title')))
                            @if(request('type') == 'courses' && !isset($discip))
                                <div class="w-full">
                                    <h4 class="text-2xl mb-0 text-capitalize mb-2">Search Result</h4>
                                    <p class="mb-3">({{ $courses->total() }} Courses Available)</p>
                                </div>
                                <div class="w-full">
                                    @foreach($courses as $key => $row)
                                        <div class="mb-3">
                                            <button class="accordionIns text-base">{{ $row->title }}</button>
                                            <div class="accordionIns_panel">
                                                @if(!$row->children->isEmpty())
                                                    @foreach($row->children as $child_key => $child)
                                                        <a href="/lecture/{{ $child->id }}"><p class="p-5">{{ $child->title }}</p></a>
                                                    @endforeach
                                                @else
                                                    <a href="/lecture/{{ $row->id }}"><p class="p-5">Show Lectures</p></a>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                    <div class="lecturePag">
                                        {{$courses->links()}}
                                    </div>
                            @elseif(request('type') == 'lectures')
                                <div class="">
                                    <div class="w-full">
                                        <h4 class="text-2xl mb-0 text-capitalize mb-2">Search Result</h4>
                                        <p class="mb-3">({{ $lectures->total() }} Lectures Available)</p>
                                    </div>
                                    @if($lectures->total() > 0)
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-9 col-xl-9" style="overflow-x: auto;">
                                        <table class="table text-sm lectureTable">
                                            <thead>
                                            <tr>
                                                <th class="w-1/12">S#</th>
                                                <th class="w-auto">Lecture</th>
                                                <th class="w-1/6">Course</th>
                                                <th class="w-1/6">Institute</th>
                                                <th class="w-1/6">Instructor</th>
                                                <th class="w-1/6">Discipline</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($lectures as $key => $lecture)
                                                <tr>
                                                    <td>{{ $lectures->firstItem() + $key }}</td>
                                                    <td class="">
                                                        <div class="flex">
                                                        <a style=""
                                                           href="/single-lecture/{{ $lecture->id }}"
                                                           target="_blank" class="text-dark small pr-2 my-auto">
                                                            <i style="font-size: 18px;" class="fa fa-play-circle"></i>
                                                        </a>
                                                        <a style=""
                                                           href="/single-lecture/{{ $lecture->id }}"
                                                           target="_blank" class="text-dark small">{{ $lecture->title }}
                                                        </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        @if(isset($lecture->lectureCategory))
                                                            <a class="text-dark small"
                                                               href="/lecture/{{ $lecture->lectureCategory->id }}">{{ $lecture->lectureCategory->title }}
                                                            </a>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(isset($lecture->lectureInstitute))
                                                            <a class="text-dark small"
                                                               href="{{ route('search','institute='.$lecture->lectureInstitute->id) }}">{{ $lecture->lectureInstitute->title }}
                                                            </a>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a style="vertical-align: middle"
                                                           href="/single-lecture/{{ $lecture->id }}" target="_blank"
                                                           class="text-dark small">{{ $lecture->lectureInstructor->title ?? '' }}</a>
                                                    </td>
                                                    <td>
                                                        @if(isset($lecture->lectureDiscipline))
                                                            <a class="text-dark small"
                                                               href="/discipline/{{ $lecture->lectureDiscipline->id }}">{{ $lecture->lectureDiscipline->title }}
                                                            </a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @endif
                                </div>
                                <div class="lecturePag">
                                    {{$lectures->links()}}
                                </div>
                            @endif
                        @elseif(request('type') == 'courses' && isset($discip))
                            <div class="w-full">
                                <h4 class="text-2xl mb-0 text-capitalize mb-2">{{ $discip->title }}</h4>
                                <p class="mb-3"></p>
                            </div>
                            <div class="w-full">
                                @foreach($discip->disc as $key => $row)
                                    <div class="mb-3">
                                        <button class="accordionIns text-base">{{ $row->title }}</button>
                                        <div class="accordionIns_panel">
                                            @if(!$row->children->isEmpty())
                                                @foreach($row->children as $child_key => $child)
                                                    <a href="/lecture/{{ $child->id }}"><p class="p-5">{{ $child->title }}</p></a>
                                                @endforeach
                                            @else
                                                <a href="/lecture/{{ $row->id }}"><p class="p-5">Show Lectures</p></a>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                    <div class="xl:col-span-3 lg:col-span-3 col-span-12">
                        <!-- SIDE COURSES -->
                        @include('layout.side_courses')
                    </div>
                </div>
            </div>
        </div>
        @forelse($pages->page_details as $page)
            {!! $page->template !!}
        @empty
            <div class="alert alert-danger row">No Section Found!</div>
        @endforelse
    </section>
    <style>
        .lecturePag .pagination {
            display: flex;
            column-gap: 2px;
            justify-content: end;
            margin-top: 8px;
        }
        .lecturePag .pagination .page-item {
            background: transparent;
            min-width: 30px;
            height: 30px;
            display: flex;
            justify-content: center;
            align-items: center;
            border: 1px solid #f9f4f4;
            transition: 0.5s ease;
        }
        .lecturePag .pagination .page-item .page-link {
            padding: 2px 8px;
        }
        .lecturePag .pagination .page-item.active {
            background: #7ac943;
            border: 1px solid #f9f4f4;
            color: #ffffff;
        }
        .lecturePag .pagination .page-item:hover {
            background: #7ac943;
            color: #fff;
        }
    </style>
@endsection
@section('custum_js')
    <script>
        var acc = document.getElementsByClassName("accordionIns");
        var i;

        for (i = 0; i < acc.length; i++) {
            acc[i].addEventListener("click", function() {
                this.classList.toggle("active");
                var accordionIns_panel = this.nextElementSibling;
                if (accordionIns_panel.style.maxHeight) {
                    accordionIns_panel.style.maxHeight = null;
                } else {
                    accordionIns_panel.style.maxHeight = accordionIns_panel.scrollHeight + "px";
                }
            });
        }
    </script>
@endsection
