<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/cleareverything', function () {
$clearcache = Artisan::call('optimize:clear');
echo "Optimize cleared<br>";
});

Route::get('/', 'HomeController@index');
Route::get('/contact', 'HomeController@contactPage')->name('contact');
Route::get('/recent_courses/{slug}', 'HomeController@recent_courses')->name('recent_courses');
Route::get('/saveContactSubdmit', 'HomeController@saveContactSubmit')->name('/saveContactSubdmit');
Route::get('/about', 'HomeController@aboutUs')->name('about');
Route::get('/projects', 'HomeController@our_projects')->name('projects');
Route::get('/project/{slug}', 'HomeController@single_project')->name('project_gallery');
Route::get('/services', 'HomeController@services')->name('services');
Route::get('/getCity/{id}', 'HomeController@getCity')->name('getCity');
Route::get('/creditors', 'HomeController@creditors')->name('creditors');
Route::get('/course_categories', 'HomeController@courseRedirect')->name('courseRedirect');
Route::get('/course_categories/{any}', 'HomeController@course')->name('course');
Route::get('/search', 'HomeController@search')->name('search');
Route::get('/discipline/{any}', 'HomeController@discipline')->name('discipline');
Route::get('/lecture/{any}', 'HomeController@lecture')->name('lecture');
Route::get('/single-course', 'HomeController@singleLectureRedirect')->name('singleLectureActive');
Route::get('/single-lecture/{any}', 'HomeController@singleLecture')->name('singleLecture');
Route::get('/mentorship', 'HomeController@mentorship')->name('mentorship');
Route::get('/faqs', 'HomeController@faqs')->name('faqs');

Route::group(['prefix' => 'admin', 'namespace' => 'Admin'], function (){
	Route::group(['middleware' => 'auth'], function (){
		Route::get('dashboard', 'HomeController@index')->name('dashboard');
		Route::get('download_doc', 'HomeController@download_doc')->name('download.doc');
		Route::get('contact_us', 'HomeController@contact_us')->name('contact_us');
        Route::get('contact_us/{id}', 'HomeController@contact_status')->name('contact.status');
		Route::get('subscribers', 'HomeController@subscribers')->name('subscribers');
		Route::get('applications', 'HomeController@applications')->name('applications');
		Route::get('applications/{id}', 'HomeController@application_status')->name('application.status');
		Route::get('settings', 'HomeController@settings')->name('settings');
		Route::post('settings/store', 'HomeController@setting_store')->name('settings.store');

        Route::resource('pages','PageController');
        Route::get('pages/status/{id}', 'PageController@status')->name('pages.status');
        Route::get('pages/delete/{id}', 'PageController@destroy')->name('pages.destroy');

        Route::resource('gallery','GalleryController');
        Route::get('gallery/delete/{id}', 'GalleryController@destroy')->name('gallery.destroy');

        Route::resource('banners','BannersController');
        Route::get('banners/status/{id}', 'BannersController@status')->name('banners.status');
        Route::get('banners/delete/{id}', 'BannersController@destroy')->name('banners.destroy');

        Route::resource('types','TypeController');
        Route::get('types/status/{id}', 'TypeController@status')->name('types.status');
		Route::get('types/delete/{id}', 'TypeController@destroy')->name('types.destroy');

        Route::resource('area','AreaController');
        Route::get('area/status/{id}', 'AreaController@status')->name('area.status');
        Route::get('area/delete/{id}', 'AreaController@destroy')->name('area.destroy');

        Route::get('news/status/{id}', 'NewsController@status')->name('news.status');
        Route::get('news/delete/{id}', 'NewsController@destroy')->name('news.destroy');
        Route::resource('news','NewsController');

        Route::put('lecture/activeAllStatus', 'LectureController@activeAllStatus')->name('lecture.activeAllStatus');
        Route::put('lecture/deactiveAllStatus', 'LectureController@deactiveAllStatus')->name('lecture.deactiveAllStatus');
        Route::put('lecture/deleteAll', 'LectureController@deleteAll')->name('lecture.deleteAll');
        Route::post('lecture/import', 'LectureController@import')->name('lecture.import');
        Route::get('/lecture/export', 'LectureController@export')->name('lecture.export');
        Route::resource('lecture','LectureController');
        Route::get('lecture/status/{id}', 'LectureController@status')->name('lecture.status');

        Route::put('level/activeAllStatus', 'LevelController@activeAllStatus')->name('level.activeAllStatus');
        Route::put('level/deactiveAllStatus', 'LevelController@deactiveAllStatus')->name('level.deactiveAllStatus');
        Route::put('level/deleteAll', 'LevelController@deleteAll')->name('level.deleteAll');
        Route::resource('level','LevelController');
        Route::get('level/status/{id}', 'LevelController@status')->name('level.status');

        Route::put('instructor/activeAllStatus', 'InstructorController@activeAllStatus')->name('instructor.activeAllStatus');
        Route::put('instructor/deactiveAllStatus', 'InstructorController@deactiveAllStatus')->name('instructor.deactiveAllStatus');
        Route::put('instructor/deleteAll', 'InstructorController@deleteAll')->name('instructor.deleteAll');
        Route::resource('instructor','InstructorController');
        Route::get('instructor/status/{id}', 'InstructorController@status')->name('instructor.status');

        Route::put('institute/activeAllStatus', 'InstituteController@activeAllStatus')->name('institute.activeAllStatus');
        Route::put('institute/deactiveAllStatus', 'InstituteController@deactiveAllStatus')->name('institute.deactiveAllStatus');
        Route::put('institute/deleteAll', 'InstituteController@deleteAll')->name('institute.deleteAll');
        Route::resource('institute','InstituteController');
        Route::get('institute/status/{id}', 'InstituteController@status')->name('institute.status');
        Route::get('institute/show_on_front/{id}', 'InstituteController@show_on_front')->name('institute.show_on_front');

        Route::put('course/activeAllStatus', 'CategoryController@activeAllStatus')->name('course.activeAllStatus');
        Route::put('course/deactiveAllStatus', 'CategoryController@deactiveAllStatus')->name('course.deactiveAllStatus');
        Route::put('course/deleteAll', 'CategoryController@deleteAll')->name('course.deleteAll');
        Route::resource('course','CategoryController');
        Route::get('course/status/{id}', 'CategoryController@status')->name('course.status');

        Route::put('discipline/activeAllStatus', 'DisciplineController@activeAllStatus')->name('discipline.activeAllStatus');
        Route::put('discipline/deactiveAllStatus', 'DisciplineController@deactiveAllStatus')->name('discipline.deactiveAllStatus');
        Route::put('discipline/deleteAll', 'DisciplineController@deleteAll')->name('discipline.deleteAll');
        Route::resource('discipline','DisciplineController');
        Route::get('discipline/status/{id}', 'DisciplineController@status')->name('discipline.status');

        Route::resource('users','UserController');
        Route::get('users/status/{id}', 'UserController@status')->name('users.status');
        Route::get('users/delete/{id}', 'UserController@destroy')->name('users.destroy');
        Route::get('profile/{id}/edit', 'UserController@profile')->name('profile.edit');
        Route::put('profile/{id}', 'UserController@update_profile')->name('profile.update');
	});
	Auth::routes();
});
