<?php $__env->startSection('title','Contact List'); ?>
<?php $__env->startSection('main_section'); ?>
    <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="row">
                                        <div class="col col-10">
                                            <h4 class="mt-0 mb-3 header-title">Contact's List</h4>
                                        </div>
                                    </div>

                                    <table id="datatable" class="table table-bordered dt-responsive">
                                        <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Full Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Message</th>
                                            <th>Created At</th>
                                            <th>Status</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($row->id); ?></td>
                                                <td><?php echo e($row->first_name .' '.$row->last_name); ?></td>
                                                <td><?php echo e($row->email); ?></td>
                                                <td><?php echo e($row->phone); ?></td>
                                                <td><?php echo e($row->message); ?></td>
                                                <td><?php echo e(date_format($row->created_at,'Y-m-d')); ?></td>
                                                <td>
                                                    <?php if($row->status == 'Pending'): ?>
                                                        <a href="<?php echo e(route('contact.status',$row->id)); ?>" class="ChangeStatus"><span class="btn-sm btn-danger btn-rounded btn-sm waves-effect waves-light">Pending</span></a>
                                                    <?php elseif($row->status == 'Processing'): ?>
                                                        <a href="<?php echo e(route('contact.status',$row->id)); ?>" class="ChangeStatus"><span class="btn-sm btn-warning btn-rounded btn-sm waves-effect waves-light">Processing</span></a>
                                                    <?php else: ?>
                                                        <a href="<?php echo e(route('contact.status',$row->id)); ?>" class="ChangeStatus"><span class="btn-sm btn-success btn-rounded btn-sm waves-effect waves-light">Completed</span></a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div> <!-- end row -->
                 </div> <!-- container -->

                </div> <!-- content -->
            </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" />
    
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="/assets/js/pages/datatables.init.js"></script>
    
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lej4learning/public_html/resources/views/admin/contact_us.blade.php ENDPATH**/ ?>