<?php $__env->startSection('page_title'); ?>
    <?php echo e($row->title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('main_content'); ?>
    <div class="heightHead"></div>
    <section class="">
        <div class="btnback">
            <div class="xl:container lg:container md:container sm:container mb-4">
                <h1 class="text-2xl font-semibold text-white uppercase text-right xl:px-0 px-4">Lecture</h1>
            </div>
        </div>
        <div>
            <!-- SEARCH -->
            <?php echo $__env->make('layout.search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="container-fluid">
            <div class="xl:container lg:container md:container sm:container xl:px-0 px-4">
                <div class="grid grid-cols-12 xl:my-4 my-6">
                    <div class="col-span-12">
                        <div class="breadcrumb">
                            <ul class="inline-block text-xs">
                                <li class="inline-block"><a href="/">Home</a></li>
                                <?php if(isset($row->parent_category->discipline_category)): ?>
                                    <li class="px-1 inline-block">>> </li>
                                    <li class="inline-block"><a href="/search?title=&type=courses&discipline=<?php echo e($row->parent_category->discipline_category->id); ?>&level=0&institute=0"><?php echo e($row->parent_category->discipline_category->title); ?></a></li>
                                    <?php if(isset($row->parent_category->parent_category)): ?>
                                        <li class="px-1 inline-block">>> </li>
                                        <li class="inline-block"><a href="/course_categories/<?php echo e($row->parent_category->parent_category->id); ?>"><?php echo e($row->parent_category->parent_category->title); ?></a></li>
                                    <?php endif; ?>
                                    <?php if(isset($row->parent_category)): ?>
                                        <li class="px-1 inline-block">>> </li>
                                        <li class="inline-block"> <a href="/course_categories/<?php echo e($row->parent_category->id); ?>"> <?php echo e($row->parent_category->title); ?></a></li>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?php
                                        if (isset($row->parent_category->parent_category->parent)){
                                            $parent_cat = \App\Category::where('id',$row->parent_category->parent_category->parent)->first();
                                        }
                                        if (isset($parent_cat->parent)){
                                            $parent = \App\Category::where('id',$parent_cat->parent)->first();
                                        }
                                        if (isset($parent->discipline)){
                                            $discipline = \App\Discipline::where('id',$parent->discipline)->firsT();
                                        }
                                    ?>
                                    <?php if(!empty($discipline) > 0): ?>
                                        <li class="px-1 inline-block">>> </li>
                                        <li class="inline-block"><a href="/search?title=&type=courses&discipline=<?php echo e($discipline->id); ?>&level=0&institute=0"><?php echo e($discipline->title); ?></a></li>
                                    <?php endif; ?>
                                    <?php if(!empty($parent) > 0): ?>
                                        <li class="px-1 inline-block">>> </li>
                                        <li class="inline-block"><a href="/course_categories/<?php echo e($parent->id); ?>"><?php echo e($parent->title); ?></a></li>
                                    <?php endif; ?>
                                    <?php if(!empty($parent_cat) > 0): ?>
                                        <li class="px-1 inline-block">>> </li>
                                        <li class="inline-block"><?php echo e($parent_cat->title); ?></li>
                                    <?php endif; ?>
                                    <?php if(isset($row->parent_category->parent_category)): ?>
                                        <li class="px-1 inline-block">>> </li>
                                        <li class="inline-block"><?php echo e($row->parent_category->parent_category->title); ?></li>
                                    <?php endif; ?>
                                    <?php if(isset($row->parent_category)): ?>
                                        <li class="px-1 inline-block">>> </li>
                                        <li class="inline-block"><a href="/course_categories/<?php echo e($row->parent_category->id); ?>"><?php echo e($row->parent_category->title); ?></a></li>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <li class="px-1 inline-block">>> </li>
                                <li class="inline-block"><a href="/lecture/<?php echo e($row->id); ?>"><?php echo e($row->title); ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="xl:container lg:container md:container sm:container">
                <div class="grid grid-cols-12 gap-6 xl:my-12 lg:my-8 my-6 xl:px-0 px-4">
                    <div class="col-span-12">
                        <h4 class="text-2xl mb-0 text-capitalize mb-2 font-medium"><?php echo e($row->title); ?></h4>
                        <p class="">(<?php echo e($lectures->total()); ?> Lectures Available)</p>
                    </div>
                    <div class="xl:col-span-9 lg:col-span-9 col-span-12">
                        <div class="">
                            <div class="col-12 col-sm-12 col-md-12 col-lg-9 col-xl-9" style="overflow-x: auto;">
                                <table class="table lectureTable">
                                    <thead>
                                    <tr>
                                        <th class="w-auto">S#</th>
                                        <th class="w-auto">Lecture</th>
                                        <th class="w-1/6">Course</th>
                                        <th class="w-1/6">Institute</th>
                                        <th class="w-1/6">Instructor</th>
                                        <th class="w-1/6">Discipline</th>
                                    </tr>
                                    </thead>
                                    <tbody class="text-xs">
                                    <?php $__currentLoopData = $lectures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lecture): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($lectures->firstItem() + $key); ?></td>
                                        <td>
                                            <a href="/single-lecture/<?php echo e($lecture->id); ?>" target="_blank">
                                            <ul>
                                                <li class="lecturePlay">
                                                    <div class="pr-2">
                                                            <i style="font-size: 18px;" class="fa fa-play-circle"></i>
                                                    </div>
                                                    <div>
                                                       <?php echo e($lecture->title ?? ''); ?>

                                                    </div>
                                                </li>
                                            </ul>
                                            </a>
                                        </td>
                                        <td>
                                            <a class="text-dark small"
                                               href="/lecture/<?php echo e($lecture->lectureCategory->id); ?>"><?php echo e($lecture->lectureCategory ? $lecture->lectureCategory->title : ''); ?></a>
                                        </td>
                                        <td>
                                            <a class="text-dark small"
                                               href="/search?title=&type=courses&discipline=0&level=0&institute=<?php echo e($lecture->lectureInstitute->id); ?>"><?php echo e($lecture->lectureInstitute ? $lecture->lectureInstitute->title : ''); ?></a>
                                        </td>
                                        <td>
                                            <a style="vertical-align: middle"
                                               href="/single-lecture/<?php echo e($lecture->id); ?>"
                                               target="_blank" class="text-dark small"><?php echo e($lecture->lectureInstructor ? $lecture->lectureInstructor->title : ''); ?></a>
                                        </td>
                                        <td>
                                            <a class="text-dark small"
                                               href="/discipline/<?php echo e($lecture->lectureDiscipline->id); ?>"><?php echo e($lecture->lectureDiscipline->title ? $lecture->lectureDiscipline->title : ''); ?></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="lecturePag">
                            <?php echo e($lectures->links()); ?>

                        </div>
                    </div>
                    <div class="xl:col-span-3 lg:col-span-3 col-span-12">
                        <!-- SIDE COURSES -->
                        <?php echo $__env->make('layout.side_courses', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $pages->page_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php echo $page->template; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="alert alert-danger row">No Section Found!</div>
        <?php endif; ?>
        <style>
            .lecturePag .pagination {
                display: flex;
                column-gap: 2px;
                justify-content: end;
                margin-top: 8px;
            }
            .lecturePag .pagination .page-item {
                background: transparent;
                min-width: 30px;
                height: 30px;
                display: flex;
                justify-content: center;
                align-items: center;
                border: 1px solid #f9f4f4;
                transition: 0.5s ease;
            }
            .lecturePag .pagination .page-item .page-link {
                padding: 2px 8px;
            }
            .lecturePag .pagination .page-item.active {
                background: #7ac943;
                border: 1px solid #f9f4f4;
                color: #ffffff;
            }
            .lecturePag .pagination .page-item:hover {
                background: #7ac943;
                color: #fff;
            }
        </style>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lej4learning/public_html/resources/views/lecture.blade.php ENDPATH**/ ?>