<?php $__env->startSection('title',isset($row->id) ? $page_title = 'Edit Lecture' : $page_title = 'Create Lecture'); ?>
<?php $__env->startSection('main_section'); ?>
    <div class="content-page">
        <div class="content">
        <?php
            $action = isset($row->id) ? route('lecture.update',$row->id) : route('lecture.store');
            $title = isset($row->id) ? $row->title : old('title');
            $course_number = isset($row->id) ? $row->course_number : old('course_number');
            $course_video_link = isset($row->id) ? $row->course_video_link : old('course_video_link');
            $keywords = isset($row->id) ? $row->keywords : old('keywords');
            $course_content = isset($row->id) ? $row->course_content : old('course_content');
        ?>
        <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="m-t-0 header-title"><?php echo e($page_title); ?></h4>
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" role="form" action="<?php echo e($action); ?>" method="post" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <?php if(isset($row->id)): ?>
                                                <?php echo method_field('put'); ?>
                                            <?php endif; ?>
                                            <?php if(isset($row->id)): ?>
                                                <div class="row">
                                                    <label class="col-sm-2  col-form-label" for="name">ID</label>
                                                    <div class="form-group col-md-8">
                                                        <?php echo e($row->id); ?>

                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Title</label>
                                                    <input type="text" id="title" placeholder="Title" class="form-control" name="title" value="<?php echo e($title); ?>" required>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Discipline</label>
                                                    <select tyle="color:black;" value="<?php echo e(old('discipline')); ?>" id="discipline" class="form-control js-example-basic-single" name="discipline">
                                                        <option value="0">----Select Discipline---</option>
                                                        <?php $__currentLoopData = $disciplines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discipline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($discipline->id); ?>" <?php if(isset($row->id)): ?> <?php echo e($row->discipline == $discipline->id  ? 'selected' : null); ?> <?php endif; ?>><?php echo e($discipline->title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Instructor</label>
                                                    <select tyle="color:black;" id="instructor" value="<?php echo e(old('instructor')); ?>" class="form-control js-example-basic-single" name="instructor">
                                                        <option value="0">----Select Instructor---</option>
                                                        <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($instructor->id); ?>" <?php if(isset($row->id)): ?> <?php echo e($row->instructor == $instructor->id  ? 'selected' : null); ?> <?php endif; ?>><?php echo e($instructor->title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Institute</label>
                                                    <select id="institute" tyle="color:black;" value="<?php echo e(old('institute')); ?>" class="form-control js-example-basic-single" name="institute">
                                                        <option value="0">----Select Institute---</option>
                                                        <?php $__currentLoopData = $institutes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $institute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($institute->id); ?>" <?php if(isset($row->id)): ?> <?php echo e($row->institute == $institute->id  ? 'selected' : null); ?> <?php endif; ?>><?php echo e($institute->title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Category</label>
                                                    <select id="category" tyle="color:black;" value="<?php echo e(old('category')); ?>" class="form-control js-example-basic-single" name="category">
                                                        <option value="0">----Select Category---</option>
                                                        <?php $__currentLoopData = $categorys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($category->id); ?>" <?php if(isset($row->id)): ?> <?php echo e($row->category == $category->id  ? 'selected' : null); ?> <?php endif; ?>><?php echo e($category->title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Level</label>
                                                    <select id="level" style="color:black;" value="<?php echo e(old('level')); ?>" class="form-control js-example-basic-single" name="level">
                                                        <option value="0">----Select Level---</option>
                                                        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($level->id); ?>" <?php if(isset($row->id)): ?> <?php echo e($row->level == $level->id  ? 'selected' : null); ?> <?php endif; ?>><?php echo e($level->title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Course Number</label>
                                                    <input type="text" id="course_number" placeholder="Course Number" class="form-control" name="course_number" value="<?php echo e($course_number); ?>">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Course Video Link</label>
                                                    <input type="text" id="course_video_link" placeholder="Course Video Link" class="form-control" name="course_video_link" value="<?php echo e($course_video_link); ?>" required>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Extension</label>
                                                    <select type="file" value="<?php echo e(old('extension')); ?>" id="extension" class="form-control" name="extension">
                                                        <option value=".mp4" <?php if(isset($row->id)): ?> <?php echo e($row->extension == ".mp4"  ? 'selected' : null); ?> <?php endif; ?>>MP4</option>
                                                        <option value=".flv" <?php if(isset($row->id)): ?> <?php echo e($row->extension == ".flv"  ? 'selected' : null); ?> <?php endif; ?>>FLV</option>
                                                        <option value=".pdf" <?php if(isset($row->id)): ?> <?php echo e($row->extension == ".pdf"  ? 'selected' : null); ?> <?php endif; ?>>PDF</option>
                                                        <option value=".link" <?php if(isset($row->id)): ?> <?php echo e($row->extension == ".link"  ? 'selected' : null); ?> <?php endif; ?>>LINK</option>
                                                        <option value=".youtube" <?php if(isset($row->id)): ?> <?php echo e($row->extension == ".youtube"  ? 'selected' : null); ?> <?php endif; ?>>YOUTUBE</option>
                                                        <option value=".iframe" <?php if(isset($row->id)): ?> <?php echo e($row->extension == ".iframe"  ? 'selected' : null); ?> <?php endif; ?>>iframe</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-8">
                                                    <label class="col-form-label" for="name">Keywords</label>
                                                    <input type="text" class="form-control" name="keywords" value="<?php echo e($keywords); ?>" placeholder="Keywords">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Course Feature Image</label>
                                                    <input type="file" id="course_feature_image" class="form-control" name="course_feature_image">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-12">
                                                    <label class="col-form-label" for="name">Course Content</label>
                                                    <textarea id="summernote" type="text" class="form-control" name="course_content" rows="5" placeholder="Course Content"><?php echo e($course_content); ?></textarea>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col col-10"></div>
                                                <div class="col col-2">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                    <a href="<?php echo e(route('lecture.index')); ?>" class="btn btn-danger">Cancel</a>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->
                        </div> <!-- end card-box -->
                    </div><!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->

        </div> <!-- content -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
        <link href="/assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css" />
    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script src="/assets/js/mask.js"></script>
    
    <script src="/assets/libs/select2/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $("#instructor").select2();
            $("#institute").select2();
            $("#category").select2();
            $("#discipline").select2();
            $("#level").select2();
            $('#summernote').summernote({
                tabsize: 2,
                height: 150,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lej4learning/public_html/resources/views/admin/lecture/form.blade.php ENDPATH**/ ?>