<?php $__env->startSection('page_title'); ?>
    Search <?php echo e(request('type')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('main_content'); ?>
    <div class="heightHead"></div>
    <section class="">
        <div class="btnback">
            <div class="xl:container lg:container md:container sm:container mb-4">
                <h1 class="text-2xl font-semibold text-white uppercase text-right xl:px-0 px-4">Search <?php echo e(request('type')); ?></h1>
            </div>
        </div>
        <div>
            <!-- SEARCH -->
            <?php echo $__env->make('layout.search', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="container-fluid">
            <div class="xl:container lg:container md:container sm:container xl:px-0 px-4">
                <div class="grid grid-cols-12 xl:my-4 my-6">
                    <div class="col-span-12">
                        <div class="breadcrumb">
                            <ul class="inline-block text-xs">
                                <li class="inline-block"><a href="/">Home</a></li>
                                <?php if(request('type') == 'courses' && isset($discip)): ?>
                                    <li class="px-1 inline-block"> >></li>
                                    <li class="inline-block"><a href="/search?title=&type=courses&discipline=<?php echo e($discip->id); ?>&level=0&institute=0"><?php echo e($discip->title); ?></a></li>
                                <?php else: ?>
                                    <li class="px-1 inline-block"> >></li>
                                    <li class="inline-block">search</li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="xl:container lg:container md:container sm:container">
                <div class="grid grid-cols-12 gap-6 xl:my-12 lg:my-8 my-6 xl:px-0 px-4">
                    <div class="xl:col-span-9 lg:col-span-9 col-span-12">
                        <?php if(isset($message)): ?>
                            <div class="text-green-400 bg-green-200 py-2 px-6 text-center">
                                <?php echo e($message); ?>

                            </div>
                        <?php endif; ?>
                        <?php if(request('level') != 0 || request('institute') != 0 || !empty(request('title'))): ?>
                            <?php if(request('type') == 'courses' && !isset($discip)): ?>
                                <div class="w-full">
                                    <h4 class="text-2xl mb-0 text-capitalize mb-2">Search Result</h4>
                                    <p class="mb-3">(<?php echo e($courses->total()); ?> Courses Available)</p>
                                </div>
                                <div class="w-full">
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-3">
                                            <button class="accordionIns text-base"><?php echo e($row->title); ?></button>
                                            <div class="accordionIns_panel">
                                                <?php if(!$row->children->isEmpty()): ?>
                                                    <?php $__currentLoopData = $row->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child_key => $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="/lecture/<?php echo e($child->id); ?>"><p class="p-5"><?php echo e($child->title); ?></p></a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <a href="/lecture/<?php echo e($row->id); ?>"><p class="p-5">Show Lectures</p></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                    <div class="lecturePag">
                                        <?php echo e($courses->links()); ?>

                                    </div>
                            <?php elseif(request('type') == 'lectures'): ?>
                                <div class="">
                                    <div class="w-full">
                                        <h4 class="text-2xl mb-0 text-capitalize mb-2">Search Result</h4>
                                        <p class="mb-3">(<?php echo e($lectures->total()); ?> Lectures Available)</p>
                                    </div>
                                    <?php if($lectures->total() > 0): ?>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-9 col-xl-9" style="overflow-x: auto;">
                                        <table class="table text-sm lectureTable">
                                            <thead>
                                            <tr>
                                                <th class="w-1/12">S#</th>
                                                <th class="w-auto">Lecture</th>
                                                <th class="w-1/6">Course</th>
                                                <th class="w-1/6">Institute</th>
                                                <th class="w-1/6">Instructor</th>
                                                <th class="w-1/6">Discipline</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $lectures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lecture): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($lectures->firstItem() + $key); ?></td>
                                                    <td class="">
                                                        <div class="flex">
                                                        <a style=""
                                                           href="/single-lecture/<?php echo e($lecture->id); ?>"
                                                           target="_blank" class="text-dark small pr-2 my-auto">
                                                            <i style="font-size: 18px;" class="fa fa-play-circle"></i>
                                                        </a>
                                                        <a style=""
                                                           href="/single-lecture/<?php echo e($lecture->id); ?>"
                                                           target="_blank" class="text-dark small"><?php echo e($lecture->title); ?>

                                                        </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php if(isset($lecture->lectureCategory)): ?>
                                                            <a class="text-dark small"
                                                               href="/lecture/<?php echo e($lecture->lectureCategory->id); ?>"><?php echo e($lecture->lectureCategory->title); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if(isset($lecture->lectureInstitute)): ?>
                                                            <a class="text-dark small"
                                                               href="<?php echo e(route('search','institute='.$lecture->lectureInstitute->id)); ?>"><?php echo e($lecture->lectureInstitute->title); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <a style="vertical-align: middle"
                                                           href="/single-lecture/<?php echo e($lecture->id); ?>" target="_blank"
                                                           class="text-dark small"><?php echo e($lecture->lectureInstructor->title ?? ''); ?></a>
                                                    </td>
                                                    <td>
                                                        <?php if(isset($lecture->lectureDiscipline)): ?>
                                                            <a class="text-dark small"
                                                               href="/discipline/<?php echo e($lecture->lectureDiscipline->id); ?>"><?php echo e($lecture->lectureDiscipline->title); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="lecturePag">
                                    <?php echo e($lectures->links()); ?>

                                </div>
                            <?php endif; ?>
                        <?php elseif(request('type') == 'courses' && isset($discip)): ?>
                            <div class="w-full">
                                <h4 class="text-2xl mb-0 text-capitalize mb-2"><?php echo e($discip->title); ?></h4>
                                <p class="mb-3"></p>
                            </div>
                            <div class="w-full">
                                <?php $__currentLoopData = $discip->disc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="mb-3">
                                        <button class="accordionIns text-base"><?php echo e($row->title); ?></button>
                                        <div class="accordionIns_panel">
                                            <?php if(!$row->children->isEmpty()): ?>
                                                <?php $__currentLoopData = $row->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child_key => $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a href="/lecture/<?php echo e($child->id); ?>"><p class="p-5"><?php echo e($child->title); ?></p></a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <a href="/lecture/<?php echo e($row->id); ?>"><p class="p-5">Show Lectures</p></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="xl:col-span-3 lg:col-span-3 col-span-12">
                        <!-- SIDE COURSES -->
                        <?php echo $__env->make('layout.side_courses', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $pages->page_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php echo $page->template; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="alert alert-danger row">No Section Found!</div>
        <?php endif; ?>
    </section>
    <style>
        .lecturePag .pagination {
            display: flex;
            column-gap: 2px;
            justify-content: end;
            margin-top: 8px;
        }
        .lecturePag .pagination .page-item {
            background: transparent;
            min-width: 30px;
            height: 30px;
            display: flex;
            justify-content: center;
            align-items: center;
            border: 1px solid #f9f4f4;
            transition: 0.5s ease;
        }
        .lecturePag .pagination .page-item .page-link {
            padding: 2px 8px;
        }
        .lecturePag .pagination .page-item.active {
            background: #7ac943;
            border: 1px solid #f9f4f4;
            color: #ffffff;
        }
        .lecturePag .pagination .page-item:hover {
            background: #7ac943;
            color: #fff;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custum_js'); ?>
    <script>
        var acc = document.getElementsByClassName("accordionIns");
        var i;

        for (i = 0; i < acc.length; i++) {
            acc[i].addEventListener("click", function() {
                this.classList.toggle("active");
                var accordionIns_panel = this.nextElementSibling;
                if (accordionIns_panel.style.maxHeight) {
                    accordionIns_panel.style.maxHeight = null;
                } else {
                    accordionIns_panel.style.maxHeight = accordionIns_panel.scrollHeight + "px";
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lej4learning/public_html/resources/views/search.blade.php ENDPATH**/ ?>