<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Applications extends Model
{
    protected $fillable = [
        'first_name', 'email', 'phone', 'document', 'last_name', 'job_id','status'
    ];

    protected $appends = ['full_name'];

    public function job()
    {
        return $this->belongsTo(Jobs::class, 'job_id', 'id');
    }

    public function getFullNameAttribute()
    {
        return $this->first_name . ' ' . $this->last_name;
    }
}
