<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'category';

    protected $fillable = [
        'title', 'discipline', 'parent', 'status', 'created_by', 'deleted_at', 'deleted_by', 'updated_by'
    ];

    public function children(){
        return $this->hasMany(Category::class,'parent','id')->select('id','title','parent')->with('children')->where(['deleted' => 0, 'status' => 1]);
    }

    public function lecture(){
        return $this->hasMany(Lecture::class,'category','id');
    }

    public function parent_category(){
        return $this->belongsTo(Category::class,'parent','id')->select('id','title','parent','discipline');
    }

    public function discipline_category(){
        return $this->belongsTo(Discipline::class,'discipline','id')->select('id','title');
    }
}
