<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Banners;
use Illuminate\Support\Facades\DB;
use Str;
use Illuminate\Support\Facades\Validator;
use File;

class BannersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $banners = Banners::where('active',1)->get();
        return view('admin.banner.index', compact('banners'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $row = [
            'title' => null,
            'banner_details' => [
                [
                    'title' => null,
                    'description' => null,
                    'src' =>  null,
                    'banner' =>  null,
                    'sort' => null,
                    'link' => null,
                    'editor' => null
                ]
            ]
        ];

        return view('admin.banner.form', compact('row'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|unique:banners,title',
            'banner_details' => 'array|min:1',
            'banner_details.*.sort' => 'required|numeric',
            'banner_details.*.title' => 'required',
            'banner_details.*.src' => 'required_if:banner_details.*.banner,null|mimes:png,jpg,jpeg,webm,mp4',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $fileName = null;
        $model = new Banners();
        $model->fill($request->except('banner_details'));
        $model['slug'] = Str::slug($request->title, '-');
        $model['status'] = '0';
        $data = [];
        foreach ($request->banner_details as $key => $detail) {
            if ($detail['src']) {
                $file = $detail['src'];
                $fileName = '/banners/' . md5($file->getClientOriginalName()) . time() . "." . $file->getClientOriginalExtension();
                $file->move('./uploads/banners', $fileName);
            }
            $detail['banner'] = $fileName;
            $detail['slug'] = Str::slug($detail['title'], '-');
            $data[] = $detail;
        }
        DB::transaction(function () use ($model, $data) {
            $model->storeHasMany([
                'banner_details' => $data
            ]);
        });
        return redirect()->to(route('banners.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = Banners::with('banner_details')->find($id);
        return view('admin.banner.form', compact('row'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'banner_details' => 'array|min:1',
            'banner_details.*.sort' => 'required|numeric',
            'banner_details.*.title' => 'required',
//            'banner_details.*.banner' => 'required|mimes:png,jpg,jpeg,webm,mp4',
            'banner_details.*.src' => 'required_if:banner_details.*.banner,null|mimes:png,jpg,jpeg,webm,mp4',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $model = Banners::find($id);
        $model->fill($request->except('banner_details'));
        $model['slug'] = Str::slug($request->title, '-');
        $data = [];
        $fileName = [];
        for ($i = 0; $i < count($model->banner_details); $i++) {
            $fileName[] = (isset($model->banner_details[$i]->banner)) ? $model->banner_details[$i]->banner : null;
        }
        foreach ($request->banner_details as $key => $detail) {
            if (isset($detail['src'])) {
                $file = $detail['src'];
                $fileName[$key] = '/banners/' . md5($file->getClientOriginalName()) . time() . "." . $file->getClientOriginalExtension();
                $file->move('./uploads/banners', $fileName[$key]);
                if(isset($model->banner_details[$key]))
                    File::delete('./uploads' . $model->banner_details[$key]->banner);
            }
            $detail['banner'] = $fileName[$key];
            $detail['slug'] = Str::slug($detail['title'], '-');
            $data[] = $detail;
        }
        DB::transaction(function () use ($model, $data) {
            $model->updateHasMany([
                'banner_details' => $data
            ]);
        });
        return redirect()->to(route('banners.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $banner = Banners::find($id);
//        foreach ($banner->banner_details as $row) {
//            if (File::exists('./uploads' . $row->banner))
//                File::delete('./uploads' . $row->banner);
//        }
        $banner->active = 0;
        $banner->save();
//        $banner->delete();
        return redirect()->to(route('banners.index'));
    }

    public function status(Request $request, $id)
    {
        if ($request->ajax()) {
            $banner = Banners::find($id);
            $newStatus = ($banner->status == '0') ? '1' : '0';
            $banner->update(['status' => $newStatus]);
            return $newStatus;
        }
        return redirect()->back();
    }
}
