<?php

namespace App\Http\Controllers\Admin;

use App\Category;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\News;
use Illuminate\Support\Facades\DB;
use Str;
use File;
use Validator;

class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $result = News::where('deleted',0)->get();
        return view('admin.news.index', compact('result'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.news.form');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'content' => 'required',
        ]);
        $data = new News();
        $data->fill($request->except('_token'));
        $data['slug'] = Str::slug($request->title, '-');
        $data['status'] = 1;
        $data->save();
        return redirect()->to(route('news.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $row = News::findOrFail($id);
        return view('admin.news.form', compact('row'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'content' => 'required',
        ]);
        $data = News::find($id);
        $data->fill($request->except('_token'));
        $data['slug'] = Str::slug($request->title, '-');
        $data->save();
        return redirect()->to(route('news.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $row = News::find($id);

            $row->deleted = 1;
            $row->save();
            return 'true';
        }
        return redirect()->back();
    }

    public function status(Request $request, $id)
    {
        if ($request->ajax()) {
            $banner = News::find($id);
            $newStatus = ($banner->status == '0') ? '1' : '0';
            $banner->update(['status' => $newStatus]);
            return $newStatus;
        }
        return redirect()->back();
    }
}
