<?php

namespace App\Http\Controllers\Admin;

use App\Jobs;
use App\PageDetails;
use App\Pages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use App\Types;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use File;

class PageController extends Controller
{
    public function index()
    {
        $pages = Pages::with('page_details')->get();
        return view('admin.pages.index', compact('pages'));
    }

    public function create()
    {
        return view('admin.pages.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|unique:pages,title',
            'page_details.*.title' => 'required',
//            'page_details.*.template' => 'required',
        ]);
        $fileName = null;
        if (request()->hasFile('meta_image')) {
            $file = request()->file('meta_image');
            $fileName = '/pages/' . md5($file->getClientOriginalName()) . time() . "." . $file->getClientOriginalExtension();
            $file->move('./uploads/pages', $fileName);
        }

        $model = new Pages();
        $model->fill($request->except('page_details'));
        $model->meta_image = $fileName;
        $model->status = 0;
        $model->slug = Str::slug($request->title,'-');
        $model->user_id = Auth::id();
        DB::transaction(function () use ($model, $request) {
            $model->storeHasMany([
                'page_details' => $request->page_details
            ]);
            $model->save();
        });

        return redirect()->to(route('pages.index'));
    }

    public function edit($id)
    {
        $row = Pages::with('page_details')->find($id);
        return view('admin.pages.form',compact('row'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'page_details.*.title' => 'required',
//            'page_details.*.template' => 'required',
        ]);
        if ($id > 1){
            $request->validate(['title'=>'required|unique:pages,title,'.$id]);
        }
        $model = Pages::with('page_details')->find($id);
        $fileName = ($model->meta_image) ? $model->meta_image : null;
        if (request()->hasFile('meta_image')) {
            $file = request()->file('meta_image');
            $fileName = '/pages/' . md5($file->getClientOriginalName()) . time() . "." . $file->getClientOriginalExtension();
            $file->move('./uploads/pages', $fileName);
            File::delete('./uploads'.$model->meta_image);
        }
        $model->fill($request->except('page_details'));
        $model->slug = ($request->title) ? Str::slug($request->title,'-') : null;
        $model->meta_image = $fileName;
        $data = [];
        foreach ($request->page_details as $page_detail) {
            $page_detail['slug'] = ($page_detail['title']) ? Str::slug($page_detail['title'],'-') : null;
            $data[] = $page_detail;
        }
        DB::transaction(function () use ($model, $data) {
            $model->updateHasMany([
                'page_details' => $data
            ]);
            $model->save();
        });

        return redirect()->to(route('pages.index'));
    }

    public function destroy($id)
    {
        if ($id > 1) {
            $page = Pages::find($id);
            if (File::exists($page->meta_image))
                File::delete('./uploads'.$page->meta_image);
            $page->delete();
            return redirect()->to(route('pages.index'));
        }
        return redirect()->back();
    }

    public function status(Request $request, $id)
    {
        if ($request->ajax() && $id > 1) {
            $type = Pages::find($id);
            $newStatus = ($type->status == '0') ? '1' : '0';
            $type->update([ 'status' => $newStatus ]);
            return $newStatus;
        }
        return redirect()->back();
    }
}
