<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Category;
use App\User;
use Str;
use Hash;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (auth()->user()->role != 'admin') {
            return redirect()->back();
        }
        $users = User::where('id','!=',auth()->user()->id)->get();
        return view('admin.users.index',compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (auth()->user()->role != 'admin') {
            return redirect()->back();
        }
        return view('admin.users.form');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'role' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required|min:8|confirmed'
        ]);
        $data = $request->except('_token');
        $data['status'] = '0';
        $data['password'] = Hash::make($request->password);
        User::create($data);
        return redirect()->to(route('users.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (auth()->user()->role != 'admin') {
            return redirect()->back();
        }
        $row = User::find($id);
        return view('admin.users.form',compact('row'));
    }

    public function profile($id)
    {
        return view('admin.profile');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
        ]);
        $row = User::find($id);
        $data =$request->except('_token');
        $data['password'] = Hash::make($request->password);
        $row->update($data);
        if (auth()->user()->role == 'admin') {
            return redirect()->to(route('users.index'));
        }else{
            return redirect()->back();            
        }
    }
    public function update_profile(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'password' => 'nullable|min:8|confirmed'
        ]);
        $row = User::find($id);
        $data =$request->except('_token');
        $data['password'] = Hash::make($request->password);
        $row->update($data);
        return redirect()->to(route('dashboard'));            
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = User::find($id);
        $user->delete();
        return redirect()->to(route('users.index'));
    }

    public function status($id)
    {
        $user = User::find($id);
        $user->update(['status' => ($user->status == '0') ? '1' : '0']);
        return redirect()->to(route('users.index'));
    }
}
