<?php

namespace App\Http\Controllers;

use App\AgentRegister;
use App\Applications;
use App\Area;
use App\Banners;
use App\Category;
use App\Cities;
use App\ContactUs;
use App\Countries;
use App\Discipline;
use App\Institute;
use App\JobRoles;
use App\Jobs;
use App\Lecture;
use App\Level;
use App\Pages;
use App\Projects;
use App\News;
use App\ProjectsGallery;
use App\Settings;
use App\Interest;
use App\Skills;
use App\Specialties;
use App\Subscribers;
use App\Types;
use Illuminate\Http\Request;
use http\Client\Response;
use PDF;
use function Couchbase\defaultDecoder;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
//    public function __construct()
//    {
//        $this->middleware('auth');
//    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $total_courses = Lecture::where(['deleted' => 0, 'status' => 1])->count();
        $settings = Settings::first();
        $pages = Pages::with('page_details')->whereNull('slug')->first();
//        dd($pages);
        $news = News::where(['status' => 1, 'deleted' => 0])->latest('id')->get();
        $institutes = Institute::select('id', 'title', 'image' ,'show_on_front')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::with('disc','disc.children','disc.children.lecture')->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        foreach ($disciplines as $key => $row){
            $row->count = Lecture::select('id')->where(['discipline' => $row->id, 'status' => 1])->count();
            foreach($row->disc as $course){
                $course->count = 0;
                $arr=[];
                $children = $this->get_children_array($course->id,$arr);
                if($children) {
                    $ids = implode(',', $children);
                    $ids .= ',' . $course->id;
                } else {
                    $ids = $course->id;
                }
                $ids = explode(',', $ids);
                $course->count = Lecture::whereIn('category',$ids)->where([ 'status' => 1, 'discipline' => $row->id ])->count();
            }
        }
        return view('index', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'total_courses', 'news'));
    }

    public function get_children_array($id,$arr)
    {
        $result = \App\Category::where(['parent' => $id, 'status'=> 1 ])->get();
        if($result) {
            foreach ($result as $item) {
                $arr[] = $item->id;
                $children = \App\Category::where(['parent' => $item->id, 'status'=> 1 ])->count();
                if($children > 0){
                    $arr = $this->get_children_array($item->id,$arr);
                }
            }
            return $arr;
        } else {
            return false;
        }
    }


    public function contact_us(Request $request)
    {
        $request->validate([
            'first_name' => 'required',
            'email' => 'required',
            'phone' => 'required',
//             'message' => 'required',
        ]);
        ContactUs::create($request->all());
        return 'true';
    }

    public function getDownload()
    {
        //PDF file is stored under project/public/download/info.pdf
        $file = public_path() . "/assets/frontend/hmr_brochure.pdf";

        $headers = array(
            'Content-Type: application/pdf',
        );

        return Response::download($file, 'filename.pdf', $headers);
    }

    public function aboutUs()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','about-us')->first();
//        dd($pages);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('about_us', compact('settings', 'banners', 'pages'));
    }

    public function creditors()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','creditors')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('creditors', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'));
    }

    public function mentorship()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','mentorship')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('mentorship', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'));
    }

    public function faqs()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','faqs')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('faqs', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'));
    }

    public function our_projects()
    {
        $settings = Settings::first();
        $projects = Projects::where('status', '1')->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('our_projects', compact('settings', 'banners', 'projects'));
    }

    public function single_project($slug)
    {
        $projects = Projects::where('status', '1')->get();
        $project = Projects::with(['projects_comparision', 'projects_gallery'])->where(['status' => '1', 'slug' => $slug])->first();
//        dd($project);
        $settings = Settings::first();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('single_project', compact('settings', 'banners', 'project', 'projects'));
    }

    public function services()
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('services', compact('settings', 'banners', 'pages'));
    }

    public function contactPage()
    {
        $settings = Settings::first();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        $scroll = false;
        $option = null;
        if (request('scroll')) {
            $scroll = true;
        }
        if (request('option')) {
            $option = request('option');
        }
        return view('contact', compact(['settings', 'scroll', 'option', 'banners']));
    }
    public function saveContactSubmit(Request $request)
    {
        $request->validate([
            'first_name' => 'required',
            'email' => 'email',
            'phone' => 'required',
        ]);
        ContactUs::create($request->all());
        return 'true';
    }

    public function course($id)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','course')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::with('disc')->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $courses = Category::select('id', 'title', 'discipline')->with('children')->where(['parent' => $id, 'deleted' => 0, 'status' => 1])->get();
//        dd($courses[0]);
        $row = Category::with('discipline_category')->findOrFail($id);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('course', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines','row', 'courses'));
    }

    public function discipline($id)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','discipline')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $courses = Category::select('id', 'title', 'discipline')->with('children')->where(['parent' => 0, 'deleted' => 0, 'status' => 1, 'discipline' => $id])->get();
//        dd($courses[0]);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('discipline', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'courses'));
    }

    public function lecture($id)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','lectures')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $row = Category::with('parent_category.discipline_category','parent_category.parent_category','parent_category.parent_category.discipline_category')->findOrFail($id);
        $lectures = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])->where(['category' => $id, 'deleted' => 0, 'status' => 1])->paginate(25);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('lecture', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'row', 'lectures'));
    }

    public function singleLecture($id)
    {
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug','lecture')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::with('disc')->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $row = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])->findOrFail($id);
        $category = Category::with('parent_category.discipline_category', 'parent_category.parent_category.discipline_category')->findOrFail($row->category);
        $categorys = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])->where(['category' => $row->category, 'deleted' => 0, 'status' => 1])->where('id','!=', $id)->paginate(25);
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        return view('single_lecture', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'row', 'categorys','category'));
    }

    public function search(Request $request)
    {
//        dd($request);
        $settings = Settings::first();
        $pages = Pages::with('page_details')->where('slug', 'search')->first();
        $institutes = Institute::select('id', 'title', 'image')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $levels = Level::select('id', 'title')->where(['deleted' => 0, 'status' => 1])->orderBy('id', 'DESC')->get();
        $disciplines = Discipline::with('disc')->select('id', 'title')->where(['deleted' => 0, 'status' => 1])->get();
        $banners = Banners::with(['banner_details' => function ($q) {
            $q->orderBy('sort');
        }])->get();
        if ($request->level != 0 || $request->institute != 0 || !empty($request->title)){
            if ($request->type == 'lectures') {
                $lectures = Lecture::with(['lectureInstructor', 'lectureCategory', 'lectureDiscipline', 'lectureInstitute', 'lectureLevel'])
                    ->when(request('title'), function ($query) {
                        $searchTitle = request()->get('title');
                        $query->where('title', 'LIKE', "%$searchTitle%");
                    })
                    ->when(request('discipline'), function ($query) {
                        $query->where('discipline', request()->get('discipline'));
                    })
                    ->when(request('type'), function ($query) {
                        $query->whereHas('lectureCategory', function ($sub_query) {
                            $sub_query->where('title', 'LIKE', "%" . request('category') . "%");
                        });
                    })
                    ->when(request('institute'), function ($query) {
                        $query->where('institute', request()->get('institute'));
                    })
                    ->when(request('level'), function ($query) {
                        $query->where('level', request()->get('level'));
                    })
                    ->where(['deleted' => 0, 'status' => 1])->paginate(25);
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'lectures'));
            }
            if ($request->type == 'courses') {
                $courses = Category::whereHas('lecture', function ($query) {
                    $query->when(request('discipline'), function ($sub_query) {
                        $sub_query->where('discipline', request()->get('discipline'));
                    })
                        ->when(request('institute'), function ($query) {
                            $query->where('institute', request()->get('institute'));
                        })
                        ->when(request('level'), function ($query) {
                            $query->where('level', request()->get('level'));
                        });
                })
                    ->where(['deleted' => 0, 'status' => 1])->paginate(25);
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'courses'));
            }
        }elseif ($request->discipline != 0) {
            if ($request->type == 'courses') {
                $discip = Discipline::with('disc.children')
                    ->where(['deleted' => 0, 'status' => 1, 'id' => $request->discipline])->first();
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines', 'discip'));
            } else{
                return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'))->with('message','please select one field to search!');
            }
        }else{
            return view('search', compact('settings', 'banners', 'pages', 'institutes', 'levels', 'disciplines'))->with('message','please select one field to search!');
        }
    }

    public function getCity($id)
    {
        return Cities::where('country_id', $id)->get();
    }

    public function recent_courses($slug)
    {
        $recent_courses = Banner_::where('slug',$slug)->first();
        dd($recent_courses);
    }

    // public function subscribe(Request $request)
    // {
    //     $request->validate([
    //         'email' => 'required|email',
    //     ]);
    //     Subscribers::create($request->all());
    //     return redirect()->back()->with('message', 'Thank You! For Subscribing');
    // }
}
