<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Lecture extends Model
{
    protected $table = 'lecture';

    protected $fillable = [
        'title', 'keywords', 'course_content', 'instructor', 'course_number', 'course_feature_image', 'category', 'discipline', 'institute', 'level', 'item_name', 'path_in_storage', 'extension', 'old_id', 'course_video_link', 'status', 'created_by', 'deleted_at', 'deleted_by', 'updated_by'
    ];

    public function lectureInstructor()
    {
        return $this->belongsTo(Instructor::class,'instructor','id')->select('id','title');
    }

    public function lectureCategory()
    {
        return $this->belongsTo(Category::class,'category','id')->select('id','title');
    }

    public function lectureDiscipline()
    {
        return $this->belongsTo(Discipline::class,'discipline','id')->select('id','title');
    }

    public function lectureInstitute()
    {
        return $this->belongsTo(Institute::class,'institute','id')->select('id','title');
    }

    public function lectureLevel()
    {
        return $this->belongsTo(Level::class,'level','id')->select('id','title');
    }

}
