$(document).ready(function ($) {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    setTimeout(function () {
        $(".alert-success").fadeOut('slow');
    }, 1000);

    $("#checkAll").click(function () {
        $(".checkSingle").prop("checked", this.checked);
    });

    $("#deactiveAllStatus").on('click', function (event) {
        event.preventDefault();
        $('tbody').addClass('table-loader');

        var statusAllValue = [];

        $("input[name='selectAll[]']:checked").each(function () {
            statusAllValue.push($(this).val());
        });

        $.ajax({
            url: $('#deactiveAllStatus').attr('href'),
            type: 'PUT',
            data: {selectAll: statusAllValue},
        })
            .done(function (data) {
                var self = $(this);
                // console.log(data);
                if (data == 'true') {
                    for (var x = 0; x < statusAllValue.length; x++) {
                        $('#status_' + statusAllValue[x]).html('<span class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span>')
                        // self.html('<span class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span>')
                        // $('#row_'+statusAllValue[x]).closest('tr').css('background-color', 'red').fadeOut('slow');
                        // setTimeout(function(){
                        //     $('#row_'+statusAllValue[x]).remove();
                        // },5000)
                        // $(this).remove();
                    }
                }
            })
            .fail(function () {
                alert("Something went wrong!");
            })

            .always(function () {
                $('tbody').removeClass('table-loader');
            });
    });

    $("#activeAllStatus").on('click', function (event) {
        event.preventDefault();
        $('tbody').addClass('table-loader');

        var statusAllValue = [];

        $("input[name='selectAll[]']:checked").each(function () {
            statusAllValue.push($(this).val());
        });

        $.ajax({
            url: $('#activeAllStatus').attr('href'),
            type: 'PUT',
            data: {selectAll: statusAllValue},
        })
            .done(function (data) {
                var self = $(this);
                // console.log(data);
                if (data == 'true') {
                    for (var x = 0; x < statusAllValue.length; x++) {
                        // self.html('<span class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span>')
                        // $('#row_'+statusAllValue[x]).closest('tr').css('background-color', 'red').fadeOut('slow');
                        // setTimeout(function(){
                        $('#status_' + statusAllValue[x]).html('<span class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span>')
                        // },5000)
                        // $(this).remove();
                    }
                }
            })
            .fail(function () {
                alert("Something went wrong!");
            })

            .always(function () {
                $('tbody').removeClass('table-loader');
            });
    });

    $("#deleteAll").on('click', function (event) {
        event.preventDefault();
        swal({
            title: "Are you sure?",
            text: "Once deleted, you will not be able to recover this file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {

                var statusAllValue = [];

                $("input[name='selectAll[]']:checked").each(function () {
                    statusAllValue.push($(this).val());
                });
                if (willDelete) {
                    swal("Your file has been deleted!", {
                        icon: "success",
                    });

                    $.ajax({
                        url: $('#deleteAll').attr('href'),
                        type: 'PUT',
                        data: {selectAll: statusAllValue},
                    })
                        .done(function (data) {
                            var self = $(this);
                            // console.log(data);
                            if (data == 'true') {
                                for (var x = 0; x < statusAllValue.length; x++) {
                                    $('#row_' + statusAllValue[x]).closest('tr').css('background-color', 'red').fadeOut('slow');
                                    setTimeout(function () {
                                        $('#row_' + statusAllValue[x]).remove();
                                    }, 5000)
                                }
                            }
                        })
                        .fail(function () {
                            alert("Something went wrong!");
                        })

                        .always(function () {
                            $('tbody').removeClass('table-loader');
                        });
                }
            });
    });

    $(".SingleStatus").on('click', function (e) {
        e.preventDefault();
        var self = $(this);
        $.get(self.attr('href'), function (data) {
            if (data == 1) {
                self.html('<span class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span>')
            } else {
                self.html('<span class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span>')
            }
        });
    });
    $(".show_on_front").on('click', function (e) {
        e.preventDefault();
        var self = $(this);
        $.get(self.attr('href'), function (data) {
            if (data == 1) {
                self.html('<input type="checkbox" name="show_on_front" id="show_on_front" checked="checked">')
                alert('show on front updated!')
            } else {
                self.html('<input type="checkbox" name="show_on_front" id="show_on_front">')
                alert('show on front updated!')
            }
        });
    });
    $(".ChangeStatus").on('click', function (e) {
        e.preventDefault();
        var self = $(this);
        $.get(self.attr('href'), function (data) {
            if (data == 'Pending') {
                self.html('<span class="btn-sm btn-danger btn-rounded btn-sm waves-effect waves-light">Pending</span>')
            } else if (data == 'Processing') {
                self.html('<span class="btn btn-warning btn-rounded btn-sm waves-effect waves-light">Processing</span>')
            } else {
                self.html('<span class="btn-sm btn-success btn-rounded btn-sm waves-effect waves-light">Completed</span>')
            }
        });
    });

    $(".SingleDelete").on('click', function (e) {
        e.preventDefault();

        swal({
            title: "Are you sure?",
            text: "Once deleted, you will not be able to recover this file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                var self = $(this);
                var url = self.attr('href');
                console.log(url)
                if (willDelete) {
                    swal("Your file has been deleted!", {
                        icon: "success",
                    });
                    $.ajax({
                        url: url,
                        type: 'delete',
                    })
                        .done(function (data) {
                            if (data == 'true') {
                                self.closest('tr').css('background-color', 'red').fadeOut('slow');
                                self.remove();
                            }
                        })
                        .fail(function () {
                            alert("Oppss! Somrthing Went Wrong");
                        })
                }
                    // else {
                //     swal("Your file is safe!");
                // }
            });
    });

});

function call_all(thisSubmit) {
    var oWhich = thisSubmit.value;
    if(document.getElementById(oWhich)){
        document.getElementById(oWhich).click();
    }
}

