@extends('admin.layout.master')

@section('title','Application List')
@section('main_section')
    <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="row">
                                        <div class="col col-10">
                                            <h4 class="mt-0 mb-3 header-title">Application's List</h4>
                                        </div>
                                    </div>

                                    <table id="datatable" class="table table-bordered dt-responsive nowrap">
                                        <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Job</th>
                                            <th>Status</th>
                                            <th>Applied On</th>
                                            <th>Attachment</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($applications as $row)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $row->full_name }}</td>
                                                <td>{{ $row->email }}</td>
                                                <td>{{ $row->phone }}</td>
                                                <td>{{ ($row->job) ? $row->job->title : 'NA' }}</td>
                                                <td>
                                                    @if ($row->status == 'Pending')
                                                        <a href="{{route('application.status',$row->id)}}" class="ChangeStatus"><span class="btn-sm btn-danger btn-rounded btn-sm waves-effect waves-light">Pending</span></a>
                                                    @elseif($row->status == 'Processing')
                                                        <a href="{{route('application.status',$row->id)}}" class="ChangeStatus"><span class="btn-sm btn-warning btn-rounded btn-sm waves-effect waves-light">Processing</span></a>
                                                    @else
                                                        <a href="{{route('application.status',$row->id)}}" class="ChangeStatus"><span class="btn-sm btn-success btn-rounded btn-sm waves-effect waves-light">Completed</span></a>
                                                    @endif
                                                </td>
                                                <td>{{ date_format($row->created_at,'Y-m-d') }}</td>
                                                @if ($row->document)
                                                    <td class="text-center"><a href="{{ route('download.doc','doc='.$row->document) }}" target="_blank"><i class="mdi mdi-attachment h3" title="Click to Download"></i></a></td>
                                                @else
                                                    <td class="text-center">-</td>
                                                @endif
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div> <!-- end row -->
                 </div> <!-- container -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" />
    {{-- <link href="/assets/libs/datatables/buttons.bootstrap4.css" rel="stylesheet" type="text/css" /> --}}
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css" />
@stop
@section('script')
    <script src="/assets/js/pages/datatables.init.js"></script>
    {{-- <script src="/assets/js/vendor.min.js"></script> --}}
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
@endsection
