@extends('admin.layout.master')

@section('title',isset($row->id) ? 'Edit Area' :'Create Area')
@section('main_section')
     <div class="content-page">
                <div class="content">
@php
    $action = isset($row->id) ? route('area.update',$row->id) : route('area.store');
@endphp
                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title">Create Area</h4>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="p-2">
                                                <form class="form-horizontal" role="form" action="{{ $action }}" method="post">
                                                    @csrf
                                                    @isset($row->id)
                                                        @method('put')
                                                    @endisset
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="area_name">Name</label>
                                                        <div class="col-sm-10">
                                                            <input type="text" id="area_name"placeholder="Title" class="form-control @error('area_name') ? is-invalid @enderror " name="area_name" value="{{ isset($row->id) ? $row->area_name : old('area_name') }}">
                                                            @error('area_name')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <div class="form-group row">
                                                        <label class="col-sm-2  col-form-label" for="description">Description</label>
                                                        <div class="col-sm-10">
                                                            <textarea type="text" id="description" class="form-control @error('description') ? is-invalid @enderror " name="description">{{ isset($row->id) ? $row->description : old('description') }}</textarea>
                                                            @error('description')
                                                                <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col col-10"></div>
                                                        <div class="col col-2">
                                                            <button type="submit" class="btn btn-primary">Save</button>
                                                            <a href="{{ route('area.index') }}" class="btn btn-danger">Cancel</a>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                    </div>
                                    <!-- end row -->

                                </div> <!-- end card-box -->
                            </div><!-- end col -->
                        </div>
                        <!-- end row -->
                    </div> <!-- container-fluid -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
@stop
@section('script')
@endsection
