@extends('admin.layout.master')

@section('title',isset($row->id) ? 'Edit Banner' :'Create Banner')
@section('main_section')
    <div class="content-page">
        <div class="content">
        @php
            $count = isset($row) ? count($row['banner_details']): 1;
            $action = isset($row->id) ? route('banners.update',$row->id) : route('banners.store');
        @endphp
        <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="m-t-0 header-title">Create Banner.</h4>
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" role="form" action="{{ $action }}" method="post"
                                              enctype="multipart/form-data">
                                            @csrf
                                            @isset($row->id)
                                                @method('put')
                                            @endisset
                                            <div class="form-group row">
                                                <label class="col-sm-2  col-form-label" for="title">Main Title</label>
                                                <div class="col-sm-9">
                                                    <input type="text" id="title" placeholder="Title"
                                                           class="form-control @error('title') ? is-invalid @enderror "
                                                           name="title"
                                                           value="{{ isset($row->id) ? $row->title : old('title') }}">
                                                    @error('title')
                                                    <span class="invalid-feedback" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            @foreach($row['banner_details'] as $key => $detail)
                                                <div class="form-html-{{$key}} form-row">
                                                    <div class="form-group col-md-3">
                                                        <label for="title" class="col-form-label">Title</label>
                                                        <input type="text" placeholder="Title"
                                                               class="form-control @error('banner_details.'.$key.'.title') ? is-invalid @enderror "
                                                               name="banner_details[{{$key}}][title]"
                                                               value="{{ isset($detail->id) ? $detail->title : old('banner_details.'.$key.'.title') }}">
                                                        @error('banner_details.'.$key.'.title')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group col-md-4">
                                                        <label for="description"
                                                               class="col-form-label">Link</label>
                                                        <input type="text" placeholder="Link"
                                                               class="form-control @error('banner_details.'.$key.'.link') ? is-invalid @enderror "
                                                               name="banner_details[{{$key}}][link]"
                                                               value="{{ isset($detail->id) ? $detail->link : old('banner_details.'.$key.'.link') }}">
                                                        @error('banner_details.'.$key.'.link')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group col-md-3">
                                                        <label for="banner" class="col-form-label">Banner</label>
                                                        <input type="file"
                                                               class="custom-file-input @error('banner_details.'.$key.'.src') ? is-invalid @enderror"
                                                               name="banner_details[{{$key}}][src]"
                                                               id="inputGroupFile01">
                                                        <input type="hidden" name="banner_details[{{$key}}][banner]" value="{{ $detail['banner'] }}">
                                                        <label class="custom-file-label mt-4"
                                                               for="inputGroupFile01">Choose file</label>
                                                        @error('banner_details.'.$key.'.src')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group col-md-1">
                                                        <label for="sort" class="col-form-label">Sort</label>
                                                        <input type="number" id="sort" placeholder="Sort"
                                                               class="form-control @error('banner_details.'.$key.'.sort') ? is-invalid @enderror "
                                                               name="banner_details[{{$key}}][sort]"
                                                               value="{{ isset($detail->id) ? $detail->sort : old('banner_details.'.$key.'.sort') }}">
                                                        @error('banner_details.'.$key.'.sort')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                        @enderror
                                                    </div>
                                                    <div class="col-md-1">
                                                        <button class="mt-4 btn btn-icon waves-effect waves-light btn-danger"
                                                                onclick="deleteRow({{$key}})" type="button"><i
                                                                    class="fas fa-times"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="form-group-{{$key}} row">
                                                    <div class="form-group pl-0 col-md-6">
                                                        <label class="col-sm-2  col-form-label"
                                                               for="description">Description</label>
                                                        <div class="col-sm-12">
                                                                    <textarea
                                                                            class="form-control homeData @error('banner_details.'.$key.'.description') ? is-invalid @enderror "
                                                                            name="banner_details[{{$key}}][description]">{{ isset($detail->id) ? $detail->description : old('banner_details.'.$key.'.description') }}</textarea>
                                                            @error('banner_details.'.$key.'.description')
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                            @enderror
                                                        </div>
                                                    </div>
                                                    @if ($detail['banner'])
                                                        <div class="col-md-6 col-xl-5 col-lg-4 natural personal">
                                                            <div class="gal-detail thumb mt-0">
                                                                <a href="#" class="image-popup">
                                                                    @php
                                                                        $ext = pathinfo(storage_path("/uploads".$detail['banner']), PATHINFO_EXTENSION);
                                                                    @endphp
                                                                    @if($ext == 'png' || $ext == 'jpg' || $ext == 'jpeg')
                                                                        <img src="/uploads/{{ $detail['banner'] }}"
                                                                             class="thumb-img img-fluid"
                                                                             alt="{{$detail['title']}}">
                                                                    @elseif($ext == 'webm' || $ext == 'mp4')
                                                                        <video width="100%" height="" loop autoplay
                                                                               muted>
                                                                            <source src="/uploads{{$detail['banner']}}"
                                                                                    type="video/mp4">
                                                                        </video>
                                                                    @endif
                                                                </a>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </div>
                                            @endforeach
                                            <div id="show-more"></div>

                                            <div class="form-group row">
                                                <div class="col-sm-11"></div>
                                                <div class="col-sm-1">
                                                    <button class="btn btn-icon waves-effect waves-light btn-success"
                                                            id="add-more"><i class="fas fa-plus"></i></button>
                                                </div>
                                            </div>

                                            <hr>
                                            <div class="row">
                                                <div class="col col-10"></div>
                                                <div class="col col-2">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                    <a href="{{ route('banners.index') }}"
                                                       class="btn btn-danger">Cancel</a>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->

                        </div> <!-- end card-box -->
                    </div><!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->

        </div> <!-- content -->
    </div>
@endsection
@section('style')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        $(document).ready(function () {
            $('.homeData').summernote({
                tabsize: 2,
                height: 120,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
            var count = @json($count);
            $("#add-more").on('click', function (e) {
                e.preventDefault();
                var datahtml = '<div class="form-html-'+count+ ' form-row">\n' +
                    '                                <div class="form-group col-md-3">\n' +
                    '                                    <label for="title" class="col-form-label">Title</label>\n' +
                    '                                    <input type="text" placeholder="Title" class="form-control @error('banner_details.'.$count.'.title') ? is-invalid @enderror " name="banner_details[' + count + '][title]" value="{{ old('banner_details.'.$count.'.title') }}">\n' +
                    '                                @error('banner_details.'.$count.'.title')\n' +
                    '                                    <span class="invalid-feedback" role="alert">\n' +
                    '                                    <strong>{{ $message }}</strong>\n' +
                    '                                    </span>\n' +
                    '                                @enderror\n' +
                    '                            </div>\n' +
                    '                            <div class="form-group col-md-4">\n' +
                    '                                <label for="title" class="col-form-label">Link</label>\n' +
                    '                                    <input type="text" placeholder="Link" class="form-control @error('banner_details.'.$count.'.link') ? is-invalid @enderror " name="banner_details[' + count + '][link]" value="{{ old('banner_details.'.$count.'.link') }}">\n' +
                    '                                @error('banner_details.'.$count.'.link')\n' +
                    '                                    <span class="invalid-feedback" role="alert">\n' +
                    '                                    <strong>{{ $message }}</strong>\n' +
                    '                                    </span>\n' +
                    '                                @enderror\n' +
                    '                            </div>\n' +
                    '            <div class="form-group col-md-3">\n' +
                    '                <label for="banner" class="col-form-label">Banner</label>\n' +
                    '                <input type="file" class="custom-file-input @error('banner_details.'.$count.'.src') ? is-invalid @enderror" name="banner_details[' + count + '][src]" id="inputGroupFile01">\n' +
                    '                 <input type="hidden" name="banner_details['+count+'][banner]" value="null">\n' +
                    '                    <label class="custom-file-label mt-4" for="inputGroupFile01">Choose file</label>\n' +
                    '                    @error('banner_details.'.$count.'.src')\n' +
                    '                        <span class="invalid-feedback" role="alert">\n' +
                    '                        <strong>{{ $message }}</strong>\n' +
                    '                        </span>\n' +
                    '                    @enderror\n' +
                    '                </div>\n' +
                    '            <div class="form-group col-md-1">\n' +
                    '                <label for="sort" class="col-form-label">Sort</label>\n' +
                    '                <input type="number" id="sort" placeholder="Sort" class="form-control @error('banner_details.'.$count.'.sort') ? is-invalid @enderror " name="banner_details[' + count + '][sort]" value="{{ old('banner_details.'.$count.'.sort') }}">\n' +
                    '                @error('banner_details.'.$count.'.sort')\n' +
                    '            <span class="invalid-feedback" role="alert">\n' +
                    '        <strong>{{ $message }}</strong>\n' +
                    '                                                                </span>\n' +
                    '                                                                        @enderror\n' +
                    '            </div>\n' +
                    '<div class="form-group pl-0 col-md-6">\n' +
                    '   <label class="col-sm-2  col-form-label" for="description">Editor</label>\n' +
                    '   <div class="col-sm-9">\n' +
                    '       <textarea class="form-control homeData @error('banner_details.'.$count.'.description') ? is-invalid @enderror " name="banner_details[' + count + '][description]" >{{ old('banner_details.'.$count.'.description') }}</textarea>\n' +
                    '       @error('banner_details.'.$count.'.description')\n' +
                    '       <span class="invalid-feedback" role="alert">\n' +
                    '       <strong>{{ $message }}</strong>\n' +
                    '   </span>\n' +
                    '       @enderror\n' +
                    '   </div>\n' +
                    '</div>'
                '            <div class="col-md-1">\n' +
                '                <button class="mt-4 btn btn-icon waves-effect waves-light btn-danger" onclick="deleteRow(' + count + ')" type="button"> <i class="fas fa-times"></i> </button>\n' +
                '                                                                    </div>\n' +
                '                                                                </div>';
                $("#show-more").append(datahtml);
                $('.homeData').summernote({
                    tabsize: 2,
                    height: 120,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'underline', 'clear']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['table', ['table']],
                        ['view', ['fullscreen', 'codeview', 'help']]
                    ]
                });
                count += 1;
                @php
                    $count = $count+1;
                @endphp
            });
        });

        function deleteRow(i) {
            if (confirm("Are You Sure?") === true) {
                $(".form-html-" + i).remove();
                $(".form-group-" + i).remove();
            }
        }
    </script>
@endsection
