@extends('admin.layout.master')

@section('title',isset($row->id) ? $page_title =  'Edit Course' : $page_title =  'Create Course')
@section('main_section')
    <div class="content-page">
        <div class="content">
        @php
            $action = isset($row->id) ? route('course.update',$row->id) : route('course.store');
        @endphp
        <!-- Start Content-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="m-t-0 header-title">{{ $page_title }}</h4>
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" role="form" action="{{ $action }}" method="post"
                                              enctype="multipart/form-data">
                                            @csrf
                                            @isset($row->id)
                                                @method('put')
                                            @endisset
                                            <div class="form-group row">
                                                <label class="col-sm-2  col-form-label" for="title">Title</label>
                                                <div class="col-sm-10">
                                                    <input type="text" id="title" placeholder="Title"
                                                           class="form-control @error('title') ? is-invalid @enderror "
                                                           name="title"
                                                           value="{{ isset($row->id) ? $row->title : old('title') }}">
                                                    @error('title')
                                                    <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-sm-2  col-form-label" for="title">Parent</label>
                                                <div class="col-sm-10">
                                                    <select tyle="color:black;" value="{{ old('parent')}}" id="parent"
                                                            class="form-control js-example-basic-single" name="parent">
                                                        <option value="0">----Select Parent---</option>
                                                        @foreach ($parents as $parent)
                                                            <option
                                                                value="{{ $parent->id }}" @isset($row->id) {{ $row->parent == $parent->id  ? 'selected' : null }} @endisset>{{ $parent->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2  col-form-label" for="title">Discipline</label>
                                                <div class="col-md-10">
                                                    <select tyle="color:black;" value="{{ old('discipline')}}"
                                                            id="discipline" class="form-control js-example-basic-single"
                                                            name="discipline">
                                                        <option value="0">----Select Discipline---</option>
                                                        @foreach ($disciplines as $discipline)
                                                            <option
                                                                value="{{ $discipline->id }}" @isset($row->id) {{ $row->discipline == $discipline->id  ? 'selected' : null }} @endisset>{{ $discipline->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col col-10"></div>
                                                <div class="col col-2">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                    <a href="{{ route('course.index') }}"
                                                       class="btn btn-danger">Cancel</a>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->
                        </div> <!-- end card-box -->
                    </div><!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->

        </div> <!-- content -->
    </div>
@endsection
@section('style')
    {{--    <link href="/assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css" />--}}
    {{--    <link href="/assets/libs/multiselect/multi-select.css"  rel="stylesheet" type="text/css" />--}}
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    {{--<script src="/assets/libs/multiselect/jquery.multi-select.js"></script>--}}
    {{--<script src="/assets/libs/select2/select2.min.js"></script>--}}


    <script>
        $(document).ready(function () {
            $("#parent").select2();
            $("#discipline").select2();
            $('#summernote').summernote({
                tabsize: 2,
                height: 150,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
@endsection
