@extends('admin.layout.master')

@section('title',$page_title =  "Course's")
@section('main_section')
    <div class="content-page">
        <div class="content">
            <!-- Start Content-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        @php
                            if (isset($row) || $errors->any()){
                                $class = 'show';
                            }else{
                                $class = 'none';
                            }
                        @endphp
                        <div class="card-box">
                            <h4 class="m-t-0 header-title">Search {{ $page_title }}</h4>
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" method="get" action="{{ route('course.index') }}">
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Title</label>
                                                    <input type="text" id="title" placeholder="Title"
                                                           class="form-control" name="title"
                                                           value="{{ request('title') ?? '' }}">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label"
                                                           for="name">Discipline</label>{{ request('discipline') }}
                                                    <select tyle="color:black;" value="{{ old('discipline')}}"
                                                            id="discipline" class="form-control js-example-basic-single"
                                                            name="discipline">
                                                        <option value="0">----Select Discipline---</option>
                                                        @foreach ($disciplines as $discipline)
                                                            <option
                                                                value="{{ $discipline->id }}" {{ request('discipline') == $discipline->id  ? 'selected' : null }}>{{ $discipline->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Parent</label>
                                                    <input type="text" id="parent" placeholder="Parent"
                                                           class="form-control" name="parent"
                                                           value="{{ request('parent') ?? '' }}">
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col col-md-10"></div>
                                                <div class="col col-md-2">
                                                    <button type="submit" class="btn btn-primary"><i
                                                            class="fa fa-search"></i> Search
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->
                        </div>

                        @if(isset($results))
                            <div class="card-box">
                                <div class="row">
                                    <div class="col col-md-6">
                                        <h4 class="mt-0 mb-3 header-title">{{ $page_title }} List</h4>
                                    </div>
                                    <div class="col col-md-6">
                                        <div class="row">
                                            <div class="col col-md-6">
                                                <select class="form-control" name="export_excel" id="export_excel"
                                                        onchange="call_all(this)" onkeypress="call_all(this)">
                                                    <option value="0">---Select---</option>
                                                    <option value="activeAllStatus">Active All status</option>
                                                    <option value="deactiveAllStatus">Deactive All Status</option>
                                                    <option value="deleteAll">Delete All</option>
                                                </select>
                                            </div>
                                            <div class="col col-md-6">
                                                <a href="{{ route('course.create') }}"
                                                   style="float: right; margin-right: 5px;"
                                                   class="btn btn-info waves-effect waves-light btn-sm"><i
                                                        class="fa fa-plus"></i>
                                                    <span>Create Lecture</span></a>
                                            </div>
                                            <a id="activeAllStatus" href="{{ route('course.activeAllStatus') }}"
                                               style="visibility: hidden;float: right; margin-right: 5px;"
                                               class="float-right btn btn-success waves-effect waves-light btn-sm"><i
                                                    class="fa fa-thumbs-up"></i> <span>Active All</span></a>
                                            <a id="deactiveAllStatus" href="{{ route('course.deactiveAllStatus') }}"
                                               style="visibility: hidden;float: right; margin-right: 5px;"
                                               class="float-right btn btn-danger waves-effect waves-light btn-sm"><i
                                                    class="fa fa-thumbs-down"></i> <span>Deactive All</span></a>
                                            <a id="deleteAll" href="{{ route('course.deleteAll') }}"
                                               style="visibility: hidden;"
                                               class="float-right btn btn-danger waves-effect waves-light btn-sm"><i
                                                    class="fa fa-trash"></i> <span>Delete All</span></a>
                                        </div>
                                    </div>
                                </div>
                                @if ($errors->has('error'))
                                    <div class="alert alert-danger">{{ $error->error }}</div>
                                @endif
                                <table class="table table-bordered dt-responsive nowrap">
                                    <thead>
                                    <tr>
                                        <th width="4%"><input type="checkbox" name="" id="checkAll"></th>
                                        <th>Id</th>
                                        <th>Parent</th>
                                        <th>Title</th>
                                        <th>Dicipline</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($results as $key => $row)
                                        <tr id="row_{{ $row->id }}">
                                            <td><input type="checkbox" name="selectAll[]" value="{{ $row->id }}"
                                                       class="checkSingle"></td>
                                            <td>{{ $row->id }}</td>
                                            <td>{{ $row->parent_category ? $row->parent_category->title : '' }}</td>
                                            <td>{{ $row->title }}</td>
                                            <td>{{ $row->discipline_category ? $row->discipline_category->title : '' }}</td>
                                            <td id="status_{{ $row->id }}">
                                                @if($row->status == '0')
                                                    <a href="{{ route('course.status',$row->id) }}"
                                                       class="SingleStatus"> <span
                                                            class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span></a>
                                                @else
                                                    <a href="{{ route('course.status',$row->id) }}"
                                                       class="SingleStatus"><span
                                                            class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span></a>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('course.destroy',$row->id) }}" class="SingleDelete"><i
                                                        class="fa fa-trash text-danger mr-2"></i></a>
                                                <a href="{{ route('course.edit',$row->id) }}"><i
                                                        class="fa fa-edit text-info"></i></a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                <div class="box-footer clearfix">
                                    <div class="row">
                                        <div class="col-md-6">
                                    <span style="display:block;font-size:15px;line-height:34px;margin:20px 0;">
{{--                                        {{($results->currentpage()-1)*$results->perpage()+1}}--}}
                                        Showing {{$results->firstItem()}} to {{$results->lastItem()}} of {{$results->total()}} entries
                                    </span>
                                        </div>
                                        <div class="col-md-6" style="margin-top: 15px;">
                                            {{ $results->links() }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div><!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->

        </div> <!-- content -->
    </div>
@endsection
@section('style')
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css"/>
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css"/>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <style>
        .none {
            display: none;
        }

        .show {
            display: block;
        }
    </style>
@stop
@section('script')
    <script src="/assets/js/pages/datatables.init.js"></script>
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

    <script>
        $(document).ready(function () {
            $("#discipline").select2();
        });

        function showCreateForm() {
            $('#create_testimonial').removeClass('none');
            $('#create_testimonial').addClass('show');
        }

        function hideForm() {
            $('#create_testimonial').removeClass('show');
            $('#create_testimonial').addClass('none');
        }
    </script>
@endsection
