@extends('admin.layout.master')

@section('title','Contact List')
@section('main_section')
    <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="row">
                                        <div class="col col-10">
                                            <h4 class="mt-0 mb-3 header-title">Contact's List</h4>
                                        </div>
                                    </div>

                                    <table id="datatable" class="table table-bordered dt-responsive">
                                        <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Full Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Message</th>
                                            <th>Created At</th>
                                            <th>Status</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($contacts as $row)
                                            <tr>
                                                <td>{{ $row->id }}</td>
                                                <td>{{ $row->first_name .' '.$row->last_name }}</td>
                                                <td>{{ $row->email }}</td>
                                                <td>{{ $row->phone }}</td>
                                                <td>{{ $row->message }}</td>
                                                <td>{{ date_format($row->created_at,'Y-m-d') }}</td>
                                                <td>
                                                    @if ($row->status == 'Pending')
                                                        <a href="{{route('contact.status',$row->id)}}" class="ChangeStatus"><span class="btn-sm btn-danger btn-rounded btn-sm waves-effect waves-light">Pending</span></a>
                                                    @elseif($row->status == 'Processing')
                                                        <a href="{{route('contact.status',$row->id)}}" class="ChangeStatus"><span class="btn-sm btn-warning btn-rounded btn-sm waves-effect waves-light">Processing</span></a>
                                                    @else
                                                        <a href="{{route('contact.status',$row->id)}}" class="ChangeStatus"><span class="btn-sm btn-success btn-rounded btn-sm waves-effect waves-light">Completed</span></a>
                                                    @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div> <!-- end row -->
                 </div> <!-- container -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" />
    {{-- <link href="/assets/libs/datatables/buttons.bootstrap4.css" rel="stylesheet" type="text/css" /> --}}
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css" />
@stop
@section('script')
    <script src="/assets/js/pages/datatables.init.js"></script>
    {{-- <script src="/assets/js/vendor.min.js"></script> --}}
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
@endsection
