@extends('admin.layout.master')

@section('title',isset($row->id) ? $page_title =  'Edit Discipline' : $page_title =  "Discipline's")
@section('main_section')
    <div class="content-page">
        <div class="content">
        @php
            $action = isset($row->id) ? route('discipline.update',$row->id) : route('discipline.store');
        @endphp
        <!-- Start Content-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        @php
                            if (isset($row) || $errors->any()){
                                $class = 'show';
                            }else{
                                $class = 'none';
                            }
                        @endphp
                        <div class="card-box {{ $class }}" id="create_testimonial">
                            <h4 class="m-t-0 header-title">{{ isset($row->id) ? 'Edit' : 'Create'  }} {{ $page_title }}</h4>
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" role="form" action="{{ $action }}" method="post"
                                              enctype="multipart/form-data">
                                            @csrf
                                            @isset($row->id)
                                                @method('put')
                                            @endisset
                                            <div class="form-group row">
                                                <label class="col-sm-2  col-form-label" for="title">Title</label>
                                                <div class="col-sm-10">
                                                    <input type="text" id="title" placeholder="Title"
                                                           class="form-control @error('title') ? is-invalid @enderror "
                                                           name="title"
                                                           value="{{ isset($row->id) ? $row->title : old('title') }}">
                                                    @error('title')
                                                    <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col col-10"></div>
                                                <div class="col col-2">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                    @if(isset($row))
                                                        <a href="{{ route('discipline.index') }}"
                                                           class="btn btn-danger">Cancel</a>
                                                    @else
                                                        <a href="#" onclick="hideForm()"
                                                           class="btn btn-danger">Cancel</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->
                        </div> <!-- end card-box -->

                        @if(isset($results))
                            <div class="card-box">
                                <div class="row">
                                    <div class="col col-md-6">
                                        <h4 class="mt-0 mb-3 header-title">{{ $page_title }} List</h4>
                                    </div>
                                    <div class="col col-md-6">
                                        <div class="row">
                                            <div class="col col-md-6">
                                                <select class="form-control" name="export_excel" id="export_excel"
                                                        onchange="call_all(this)" onkeypress="call_all(this)">
                                                    <option value="0">---Select---</option>
                                                    <option value="activeAllStatus">Active All status</option>
                                                    <option value="deactiveAllStatus">Deactive All Status</option>
                                                    <option value="deleteAll">Delete All</option>
                                                </select>
                                            </div>
                                            <div class="col col-md-6">
                                                <button style="float: right; margin-right: 5px;"
                                                        onclick="showCreateForm()"
                                                        class="btn btn-info waves-effect waves-light btn-sm"><i
                                                        class="fa fa-plus"></i> <span>Create Discipline</span></button>
                                            </div>
                                            <a id="activeAllStatus" href="{{ route('discipline.activeAllStatus') }}"
                                               style="visibility: hidden;float: right; margin-right: 5px;"
                                               class="float-right btn btn-success waves-effect waves-light btn-sm"><i
                                                    class="fa fa-thumbs-up"></i> <span>Active All</span></a>
                                            <a id="deactiveAllStatus" href="{{ route('discipline.deactiveAllStatus') }}"
                                               style="visibility: hidden;float: right; margin-right: 5px;"
                                               class="float-right btn btn-danger waves-effect waves-light btn-sm"><i
                                                    class="fa fa-thumbs-down"></i> <span>Deactive All</span></a>
                                            <a id="deleteAll" href="{{ route('discipline.deleteAll') }}"
                                               style="visibility: hidden;"
                                               class="float-right btn btn-danger waves-effect waves-light btn-sm"><i
                                                    class="fa fa-trash"></i> <span>Delete All</span></a>
                                        </div>
                                    </div>
                                </div>
                                @if ($errors->has('error'))
                                    <div class="alert alert-danger">{{ $error->error }}</div>
                                @endif
                                <div class="table-responsive">
                                    <table id="datatable" class="table table-bordered dt-responsive nowrap">
                                        <thead>
                                        <tr>
                                            <th width="4%"><input type="checkbox" name="" id="checkAll"></th>
                                            <th>#</th>
                                            <th>Id</th>
                                            <th>Title</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($results as $key => $row)
                                            @php
                                                $key = $key + 1;
                                            @endphp
                                            <tr id="row_{{ $row->id }}">
                                                <td><input type="checkbox" name="selectAll[]" value="{{ $row->id }}"
                                                           class="checkSingle"></td>
                                                <td>{{ $key }}</td>
                                                <td>{{ $row->id }}</td>
                                                <td>{{$row->title }}</td>
                                                <td id="status_{{ $row->id }}">
                                                    @if($row->status == '0')
                                                        <a href="{{ route('discipline.status',$row->id) }}"
                                                           class="SingleStatus"> <span
                                                                class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span></a>
                                                    @else
                                                        <a href="{{ route('discipline.status',$row->id) }}"
                                                           class="SingleStatus"><span
                                                                class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span></a>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('discipline.destroy',$row->id) }}"
                                                       class="SingleDelete"><i class="fa fa-trash text-danger mr-2"></i></a>
                                                    <a href="{{ route('discipline.edit',$row->id) }}"><i
                                                            class="fa fa-edit text-info"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        @endif
                    </div><!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->

        </div> <!-- content -->
    </div>
@endsection
@section('style')
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css"/>
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css"/>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <style>
        .none {
            display: none;
        }

        .show {
            display: block;
        }
    </style>
@stop
@section('script')
    <script src="/assets/js/pages/datatables.init.js"></script>
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

    <script>
        $(document).ready(function () {
            $("#skill_multi").select2();
            $('#summernote').summernote({
                tabsize: 2,
                height: 150,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });

        function showCreateForm() {
            $('#create_testimonial').removeClass('none');
            $('#create_testimonial').addClass('show');
        }

        function hideForm() {
            $('#create_testimonial').removeClass('show');
            $('#create_testimonial').addClass('none');
        }
    </script>
@endsection
