@extends('admin.layout.master')

@section('title','Gallery')
@section('main_section')
    <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="portfolioFilter">
                                    <div class="col col-2">
                                        <a href="#custom-modal" data-animation="fadein" data-plugin="custommodal" data-overlayColor="#36404a" style="float: right;" class="btn btn-info waves-effect waves-light btn-sm"><i class="fa fa-upload"></i> <span>Upload Image</span></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="port mb-2">
                            <div class="portfolioContainer row" >
                                @forelse($gallery as $row)
                                <div class="col-md-6 col-xl-3 col-lg-4 natural personal">
                                    <div class="gal-detail thumb">
                                        <a href="{{ route('gallery.edit',$row->id)  }}" class="image-popup" title="{{$row->title}}">
                                            <img src="{{$row->link}}" class="thumb-img img-fluid" alt="work-thumbnail">
                                        </a>
                                    </div>
                                </div>
                                @empty
                                    <div class="alert alert-danger">
                                        No Image Found!
                                    </div>
                                @endforelse
                            </div><!-- end portfoliocontainer-->
                        </div> <!-- End row -->
                        <div id="custom-modal" class="modal-demo">
                            <button type="button" class="close" onclick="Custombox.modal.close();">
                                <span>&times;</span><span class="sr-only">Close</span>
                            </button>
                            <h4 class="custom-modal-title">Upload Image</h4>
                            <div class="custom-modal-text">
                                <form class="form-horizontal" role="form" action="{{ route('gallery.store') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="form-group row">
                                        <label class="col-form-label col-sm-2">Image</label>
                                        <div class="col-sm-9">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input @error('image') ? is-invalid @enderror" name="image[]" id="inputGroupFile01" multiple>
                                                <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                                                @error('image')
                                                <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col col-10"></div>
                                        <div class="col col-2">
                                            <button type="submit" class="btn btn-primary">Upload</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div> <!-- content -->
            </div>
@endsection
@section('style')
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" />
    <link href="/assets/libs/custombox/custombox.min.css" rel="stylesheet">
    {{-- <link href="/assets/libs/datatables/buttons.bootstrap4.css" rel="stylesheet" type="text/css" /> --}}
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css" />
@stop
@section('script')
    <script src="/assets/libs/custombox/custombox.min.js"></script>
    <script src="/assets/js/pages/datatables.init.js"></script>
    {{-- <script src="/assets/js/vendor.min.js"></script> --}}
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
@endsection
