@extends('admin.layout.master')

@section('title',isset($row->id) ? $page_title = 'Edit Lecture' : $page_title = 'Create Lecture')
@section('main_section')
    <div class="content-page">
        <div class="content">
        @php
            $action = isset($row->id) ? route('lecture.update',$row->id) : route('lecture.store');
            $title = isset($row->id) ? $row->title : old('title');
            $course_number = isset($row->id) ? $row->course_number : old('course_number');
            $course_video_link = isset($row->id) ? $row->course_video_link : old('course_video_link');
            $keywords = isset($row->id) ? $row->keywords : old('keywords');
            $course_content = isset($row->id) ? $row->course_content : old('course_content');
        @endphp
        <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="m-t-0 header-title">{{ $page_title }}</h4>
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" role="form" action="{{ $action }}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            @isset($row->id)
                                                @method('put')
                                            @endisset
                                            @isset($row->id)
                                                <div class="row">
                                                    <label class="col-sm-2  col-form-label" for="name">ID</label>
                                                    <div class="form-group col-md-8">
                                                        {{ $row->id }}
                                                    </div>
                                                </div>
                                            @endisset
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Title</label>
                                                    <input type="text" id="title" placeholder="Title" class="form-control" name="title" value="{{ $title }}" required>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Discipline</label>
                                                    <select tyle="color:black;" value="{{ old('discipline')}}" id="discipline" class="form-control js-example-basic-single" name="discipline">
                                                        <option value="0">----Select Discipline---</option>
                                                        @foreach ($disciplines as $discipline)
                                                            <option value="{{ $discipline->id }}" @isset($row->id) {{ $row->discipline == $discipline->id  ? 'selected' : null }} @endisset>{{ $discipline->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Instructor</label>
                                                    <select tyle="color:black;" id="instructor" value="{{ old('instructor')}}" class="form-control js-example-basic-single" name="instructor">
                                                        <option value="0">----Select Instructor---</option>
                                                        @foreach ($instructors as $instructor)
                                                            <option value="{{ $instructor->id }}" @isset($row->id) {{ $row->instructor == $instructor->id  ? 'selected' : null }} @endisset>{{ $instructor->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Institute</label>
                                                    <select id="institute" tyle="color:black;" value="{{ old('institute')}}" class="form-control js-example-basic-single" name="institute">
                                                        <option value="0">----Select Institute---</option>
                                                        @foreach ($institutes as $institute)
                                                            <option value="{{ $institute->id }}" @isset($row->id) {{ $row->institute == $institute->id  ? 'selected' : null }} @endisset>{{ $institute->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Category</label>
                                                    <select id="category" tyle="color:black;" value="{{ old('category')}}" class="form-control js-example-basic-single" name="category">
                                                        <option value="0">----Select Category---</option>
                                                        @foreach ($categorys as $category)
                                                            <option value="{{ $category->id }}" @isset($row->id) {{ $row->category == $category->id  ? 'selected' : null }} @endisset>{{ $category->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Level</label>
                                                    <select id="level" style="color:black;" value="{{ old('level')}}" class="form-control js-example-basic-single" name="level">
                                                        <option value="0">----Select Level---</option>
                                                        @foreach ($levels as $level)
                                                            <option value="{{ $level->id }}" @isset($row->id) {{ $row->level == $level->id  ? 'selected' : null }} @endisset>{{ $level->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Course Number</label>
                                                    <input type="text" id="course_number" placeholder="Course Number" class="form-control" name="course_number" value="{{ $course_number }}" required>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Course Video Link</label>
                                                    <input type="text" id="course_video_link" placeholder="Course Video Link" class="form-control" name="course_video_link" value="{{ $course_video_link }}" required>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Extension</label>
                                                    <select type="file" value="{{ old('extension')}}" id="extension" class="form-control" name="extension">
                                                        <option value=".mp4" @isset($row->id) {{ $row->extension == ".mp4"  ? 'selected' : null }} @endisset>MP4</option>
                                                        <option value=".flv" @isset($row->id) {{ $row->extension == ".flv"  ? 'selected' : null }} @endisset>FLV</option>
                                                        <option value=".pdf" @isset($row->id) {{ $row->extension == ".pdf"  ? 'selected' : null }} @endisset>PDF</option>
                                                        <option value=".link" @isset($row->id) {{ $row->extension == ".link"  ? 'selected' : null }} @endisset>LINK</option>
                                                        <option value=".youtube" @isset($row->id) {{ $row->extension == ".youtube"  ? 'selected' : null }} @endisset>YOUTUBE</option>
                                                        <option value=".iframe" @isset($row->id) {{ $row->extension == ".iframe"  ? 'selected' : null }} @endisset>iframe</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-8">
                                                    <label class="col-form-label" for="name">Keywords</label>
                                                    <input type="text" class="form-control" name="keywords" value="{{ $keywords }}" placeholder="Keywords">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Course Feature Image</label>
                                                    <input type="file" id="course_feature_image" class="form-control" name="course_feature_image">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-12">
                                                    <label class="col-form-label" for="name">Course Content</label>
                                                    <textarea id="summernote" type="text" class="form-control" name="course_content" rows="5" placeholder="Course Content">{{ $course_content }}</textarea>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col col-10"></div>
                                                <div class="col col-2">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                    <a href="{{ route('lecture.index') }}" class="btn btn-danger">Cancel</a>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->
                        </div> <!-- end card-box -->
                    </div><!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->

        </div> <!-- content -->
    </div>
@endsection
@section('style')
        <link href="/assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css" />
    {{--    <link href="/assets/libs/multiselect/multi-select.css"  rel="stylesheet" type="text/css" />--}}
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script src="/assets/js/mask.js"></script>
    {{--<script src="/assets/libs/multiselect/jquery.multi-select.js"></script>--}}
    <script src="/assets/libs/select2/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $("#instructor").select2();
            $("#institute").select2();
            $("#category").select2();
            $("#discipline").select2();
            $("#level").select2();
            $('#summernote').summernote({
                tabsize: 2,
                height: 150,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
@endsection
