@extends('admin.layout.master')

@section('title',$page_title = "Lecture's")
@section('main_section')
    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">
                    <div class="col-12">
                        <div class="card-box">
                            <h4 class="m-t-0 header-title">Search {{ $page_title }}</h4>
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="row">
                                <div class="col-12">
                                    <div class="p-2">
                                        <form class="form-horizontal" method="get"
                                              action="{{ route('lecture.index') }}">
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Title</label>
                                                    <input type="text" id="title" placeholder="Title"
                                                           class="form-control" name="title"
                                                           value="{{ request('title') ?? '' }}">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Course</label>
                                                    <input type="text" id="category" placeholder="Title"
                                                           class="form-control" name="category"
                                                           value="{{ request('category') ?? '' }}">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Instructor</label>
                                                    <input type="text" id="instructor" placeholder="Instructor"
                                                           class="form-control" name="instructor"
                                                           value="{{ request('instructor') ?? '' }}">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Institute</label>
                                                    <select id="institute" tyle="color:black;"
                                                            value="{{ old('institute')}}"
                                                            class="form-control js-example-basic-single"
                                                            name="institute">
                                                        <option value="0">----Select Institute---</option>
                                                        @foreach ($institutes as $institute)
                                                            <option
                                                                value="{{ $institute->id }}" {{ request('institute') == $institute->id  ? 'selected' : null }}>{{ $institute->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label"
                                                           for="name">Discipline</label>{{ request('discipline') }}
                                                    <select tyle="color:black;" value="{{ old('discipline')}}"
                                                            id="discipline" class="form-control js-example-basic-single"
                                                            name="discipline">
                                                        <option value="0">----Select Discipline---</option>
                                                        @foreach ($disciplines as $discipline)
                                                            <option
                                                                value="{{ $discipline->id }}" {{ request('discipline') == $discipline->id  ? 'selected' : null }}>{{ $discipline->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label class="col-form-label" for="name">Level</label>
                                                    <select id="level" tyle="color:black;" value="{{ old('level')}}"
                                                            class="form-control js-example-basic-single" name="level">
                                                        <option value="0">----Select Level---</option>
                                                        @foreach ($levels as $level)
                                                            <option
                                                                value="{{ $level->id }}" {{ request('level') == $level->id  ? 'selected' : null }}>{{ $level->title }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row">
                                                <div class="col col-md-10"></div>
                                                <div class="col col-md-2">
                                                    <button type="submit" class="btn btn-primary"><i
                                                            class="fa fa-search"></i> Search
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                            <!-- end row -->
                        </div>
                        <div class="card-box">
                            <div class="row">
                                <div class="col col-md-2">
                                    <h4 class="mt-0 mb-3 header-title">{{ $page_title }} List</h4>
                                </div>
                                <div class="col col-md-10">
                                    <div class="row">
                                        <div class="col col-md-2">
                                            <select class="form-control" name="perPage" id="perPage"
                                                    onchange="perPage(this)" onkeypress="perPage(this)">
                                                <option value="10" {{ request('per_page') == "10"  ? 'selected' : null }}>10</option>
                                                <option value="20" {{ request('per_page') == "20"  ? 'selected' : null }}>20</option>
                                                <option value="50" {{ request('per_page') == "50"  ? 'selected' : null }}>50</option>
                                                <option value="100" {{ request('per_page') == "100"  ? 'selected' : null }}>100</option>
                                                <option value="500" {{ request('per_page') == "500"  ? 'selected' : null }}>500</option>
                                                <option value="1000" {{ request('per_page') == "1000"  ? 'selected' : null }}>1000</option>
{{--                                                <option value="5000" {{ request('per_page') == "5000"  ? 'selected' : null }}>5000</option>--}}
                                            </select>
                                        </div>
                                        <div class="col col-md-3">
                                            <select class="form-control" name="export_excel" id="export_excel"
                                                    onchange="call_all(this)" onkeypress="call_all(this)">
                                                <option value="0">---Select---</option>
                                                <option value="activeAllStatus">Active All status</option>
                                                <option value="deactiveAllStatus">Deactive All Status</option>
                                                <option value="deleteAll">Delete All</option>
                                            </select>
                                        </div>
                                        <div class="col col-md-2">
                                            <button class="float-right btn btn-warning btn-sm waves-effect waves-light" style="color: black;" onclick="export_data()"><i class="fa fa-file-excel"></i> <span>Export</span></button>
                                        </div>
                                        <div class="col col-md-2">
                                            <a href="" style="float: right;"
                                               onclick="event.preventDefault(); document.getElementById('input').click();">
                                                <button class="float-right btn btn-success btn-sm waves-effect waves-light"><i
                                                        class="fa fa-file-excel" style="margin-left: 5px;"></i> <span>Import Excel</span>
                                                </button>
                                            </a>
                                            <form action="{{ route('lecture.import') }}" method="post"
                                                  enctype="multipart/form-data" class="d-none" id="excel-form">
                                                @csrf
                                                <input type="file" id="input" name="file"
                                                       oninput="event.preventDefault(); document.getElementById('excel-form').submit();">
                                            </form>
                                        </div>
                                        <div class="col col-md-3">
                                            <a href="{{ route('lecture.create') }}"
                                               style="float: right; margin-right: 5px;"
                                               class="btn btn-info waves-effect waves-light btn-sm"><i
                                                    class="fa fa-plus"></i>
                                                <span>Create Lecture</span></a>
                                        </div>
                                        <a id="activeAllStatus" href="{{ route('lecture.activeAllStatus') }}"
                                           style="visibility: hidden;float: right; margin-right: 5px;"
                                           class="float-right btn btn-sm btn-success waves-effect waves-light"><i
                                                class="fa fa-thumbs-up"></i> <span>Active All</span></a>
                                        <a id="deactiveAllStatus" href="{{ route('lecture.deactiveAllStatus') }}"
                                           style="visibility: hidden;float: right; margin-right: 5px;"
                                           class="float-right btn btn-danger waves-effect waves-light btn-sm"><i
                                                class="fa fa-thumbs-down"></i> <span>Deactive All</span></a>
                                        <a id="deleteAll" href="{{ route('lecture.deleteAll') }}"
                                           style="visibility: hidden;"
                                           class="float-right btn btn-danger waves-effect waves-light btn-sm"><i
                                                class="fa fa-trash"></i> <span>Delete All</span></a>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered dt-responsive nowrap">
                                    <thead>
                                    <tr>
                                        <th width="4%"><input type="checkbox" name="" id="checkAll"></th>
                                        <th>ID</th>
                                        <th>Title</th>
                                        <th>Instructor</th>
                                        <th>Course</th>
                                        <th>Discipline</th>
                                        <th>Institute</th>
                                        <th>Level</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($results as $key => $row)
                                        <tr id="row_{{ $row->id }}">
                                            <td><input type="checkbox" name="selectAll[]" value="{{ $row->id }}"
                                                       class="checkSingle"></td>
                                            <td>{{ $row->id }}</td>
                                            <td>{{ $row->title }}</td>
                                            <td>{{ $row->lectureInstructor ? $row->lectureInstructor->title : '' }}</td>
                                            <td>{{ $row->lectureCategory ? $row->lectureCategory->title : '' }}</td>
                                            <td>{{ $row->lectureDiscipline ? $row->lectureDiscipline->title : '' }}</td>
                                            <td>{{ $row->lectureInstitute ? $row->lectureInstitute->title : '' }}</td>
                                            <td>{{ $row->lectureLevel ? $row->lectureLevel->title : '' }}</td>
                                            <td id="status_{{ $row->id }}">
                                                @if($row->status == '0')
                                                    <a href="{{ route('lecture.status',$row->id) }}"
                                                       class="SingleStatus"> <span
                                                            class="btn btn-danger btn-rounded btn-sm waves-effect waves-light">Deactive</span></a>
                                                @else
                                                    <a href="{{ route('lecture.status',$row->id) }}"
                                                       class="SingleStatus"><span
                                                            class="btn btn-success btn-rounded btn-sm waves-effect waves-light">Active</span></a>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('lecture.destroy',$row->id) }}"
                                                   class="SingleDelete"><i
                                                        class="fa fa-trash text-danger mr-2"></i></a>
                                                <a href="{{ route('lecture.edit',$row->id) }}"><i
                                                        class="fa fa-edit text-info"></i></a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="box-footer clearfix">
                                <div class="row">
                                    <div class="col-md-6">
                                    <span style="display:block;font-size:15px;line-height:34px;margin:20px 0;">
                                        Showing {{$results->firstItem()}} to {{$results->lastItem()}} of {{$results->total()}} entries
                                    </span>
                                    </div>
                                    <div class="col-md-6" style="margin-top: 15px;">
                                        {{ $results->links() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- end row -->
            </div> <!-- container -->

        </div> <!-- content -->
    </div>
@endsection
@section('style')
    <link href="/assets/libs/select2/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet"/>
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css"/>
    {{-- <link href="/assets/libs/datatables/buttons.bootstrap4.css" rel="stylesheet" type="text/css" /> --}}
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css"/>
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
    <script src="/assets/js/pages/datatables.init.js"></script>
    {{-- <script src="/assets/js/vendor.min.js"></script> --}}
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
    <script src="/assets/libs/select2/select2.min.js"></script>
    <script>
        function perPage(data) {
            var per_page = data.value;
            var title = document.getElementById("title").value;
            var category = document.getElementById("category").value;
            var instructor = document.getElementById("instructor").value;
            var institute = document.getElementById("institute").value;
            var discipline = document.getElementById("discipline").value;
            var level = document.getElementById("level").value;

            const params = new URLSearchParams(window.location.search);
            params.set('q','');
            if(per_page > 0){
                params.set("per_page",per_page);
            }else{
                if(params.has("per_page")){
                    params.delete("per_page");
                }
            }
            if(title.length > 0){
                params.set("title",title);
            }else{
                if(params.has("title")){
                    params.delete("title");
                }
            }
            if(category.length > 0){
                params.set("category",category);
            }else{
                if(params.has("category")){
                    params.delete("category");
                }
            }
            if(instructor.length > 0){
                params.set("instructor",instructor);
            }else{
                if(params.has("instructor")){
                    params.delete("instructor");
                }
            }
            if(institute > 0){
                params.set("institute",institute);
            }else{
                if(params.has("institute")){
                    params.delete("institute");
                }
            }
            if(discipline > 0){
                params.set("discipline",discipline);
            }else{
                if(params.has("discipline")){
                    params.delete("discipline");
                }
            }
            if(level > 0){
                params.set("level",level);
            }else{
                if(params.has("level")){
                    params.delete("level");
                }
            }
            window.location.href= "/admin/lecture?"+params.toString();
        }
        function export_data(){
            var per_page = document.getElementById("perPage").value;
            var title = document.getElementById("title").value;
            var category = document.getElementById("category").value;
            var instructor = document.getElementById("instructor").value;
            var institute = document.getElementById("institute").value;
            var discipline = document.getElementById("discipline").value;
            var level = document.getElementById("level").value;

            const params = new URLSearchParams(window.location.search);
            params.set('q','');
            if(per_page > 0){
                params.set("per_page",per_page);
            }else{
                if(params.has("per_page")){
                    params.delete("per_page");
                }
            }
            if(title.length > 0){
                params.set("title",title);
            }else{
                if(params.has("title")){
                    params.delete("title");
                }
            }
            if(category.length > 0){
                params.set("category",category);
            }else{
                if(params.has("category")){
                    params.delete("category");
                }
            }
            if(instructor.length > 0){
                params.set("instructor",instructor);
            }else{
                if(params.has("instructor")){
                    params.delete("instructor");
                }
            }
            if(institute > 0){
                params.set("institute",institute);
            }else{
                if(params.has("institute")){
                    params.delete("institute");
                }
            }
            if(discipline > 0){
                params.set("discipline",discipline);
            }else{
                if(params.has("discipline")){
                    params.delete("discipline");
                }
            }
            if(level > 0){
                params.set("level",level);
            }else{
                if(params.has("level")){
                    params.delete("level");
                }
            }
            window.open("/admin/lecture/export?"+params.toString());
        }
        $(document).ready(function () {
            $("#institute").select2();
            $("#discipline").select2();
            $("#level").select2();
        });
    </script>
@endsection
