@extends('admin.layout.master')

@section('title','Subscriber List')
@section('main_section')
    <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card-box">
                                    <div class="row">
                                        <div class="col col-10">
                                            <h4 class="mt-0 mb-3 header-title">Subscriber's List</h4>
                                        </div>
                                    </div>

                                    <table id="datatable" class="table table-bordered dt-responsive nowrap">
                                        <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Email</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($subs as $sub)
                                            <tr>
                                                <td>{{ $sub->id }}</td>
                                                <td>{{ $sub->email }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div> <!-- end row -->
                 </div> <!-- container -->

                </div> <!-- content -->
            </div>
@endsection
@section('style')
    <link href="/assets/libs/datatables/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" />
    {{-- <link href="/assets/libs/datatables/buttons.bootstrap4.css" rel="stylesheet" type="text/css" /> --}}
    <link href="/assets/libs/datatables/select.bootstrap4.css" rel="stylesheet" type="text/css" />
@stop
@section('script')
    <script src="/assets/js/pages/datatables.init.js"></script>
    {{-- <script src="/assets/js/vendor.min.js"></script> --}}
    <script src="/assets/libs/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/libs/datatables/dataTables.bootstrap4.js"></script>
@endsection
