@extends('layout.master')
@section('page_title')
    {{ $row->title }}
@endsection
@section('main_content')
    <div class="heightHead"></div>
    <section class="">
        <div class="btnback">
            <div class="xl:container lg:container md:container sm:container mb-4">
                <h1 class="text-2xl font-semibold text-white uppercase text-right xl:px-0 px-4">Course</h1>
            </div>
        </div>
        <div>
            <!-- SEARCH -->
            @include('layout.search')
        </div>
        <div class="container-fluid">
            <div class="xl:container lg:container md:container sm:container xl:px-0 px-4">
                <div class="grid grid-cols-12 xl:my-4 my-6">
                    <div class="col-span-12">
                        <div class="breadcrumb">
                            <ul class="inline-block text-xs">
                                <li class="inline-block"><a href="/">Home</a></li>
                                @if(isset($row->discipline_category))
                                    <li class="px-1 inline-block"> >></li>
                                    <li class="inline-block"><a href="/search?title=&type=courses&discipline={{ $row->discipline_category->id }}&level=0&institute=0">{{ $row->discipline_category->title }}</a></li>
                                @else
                                    @php
                                        $parent_cat = \App\Category::where('id',$row->parent)->first();
                                        $parent = \App\Category::where('id',$parent_cat->parent)->first();
                                        if (isset($parent->discipline)){
                                            $discipline = \App\Discipline::where('id',$parent->discipline)->firsT();
                                        }
                                    @endphp
                                    @if(!empty($discipline) > 0)
                                        <li class="px-1 inline-block"> >></li>
                                        <li class="inline-block"><a href="/search?title=&type=courses&discipline={{ $discipline->id }}&level=0&institute=0">{{ $discipline->title }}</a></li>
                                    @endif
                                    @if(!empty($parent) > 0)
                                        <li class="px-1 inline-block"> >></li>
                                        <li class="inline-block"><a href="/course_categories/{{ $parent->id }}">{{ $parent->title }}</a></li>
                                    @endif
                                    @if(!empty($parent_cat) > 0)
                                        <li class="px-1 inline-block"> >></li>
                                        <li class="inline-block"><a href="/course_categories/{{ $parent_cat->id }}">{{ $parent_cat->title }}</a></li>
                                    @endif
                                @endif
                                <li class="px-1 inline-block"> >></li>
                                <li class="inline-block"><a href="/course_categories/{{ $row->id }}">{{ $row->title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="xl:container lg:container md:container sm:container xl:px-0 px-4">
                <div class="grid grid-cols-12 gap-6 xl:mb-12 lg:mb-8 mb-6">
                    <div class="xl:col-span-9 lg:col-span-9 col-span-12">
                        <div class="w-full">
                            <h4 class="text-2xl mb-0 text-capitalize mb-2 font-medium">{{ $row->title }}</h4>
                            @foreach($courses as $key => $row)
                                <div class="mb-3">
                                    <button class="accordionCur text-base">{{ $row->title }}</button>
                                    <div class="accordionCur_panel">
                                        @if(!$row->children->isEmpty())
                                            @foreach($row->children as $child_key => $child)
                                                @if(!$child->children->isEmpty())
                                                    <a href="/course_categories/{{ $child->id }}"><p class="p-5">{{ $child->title }}</p></a>
                                                @else
                                                    <a href="/lecture/{{ $child->id }}"><p class="p-5">{{ $child->title }}</p></a>
                                                @endif
                                            @endforeach
                                        @else
                                            <a href="/lecture/{{ $row->id }}"><p class="p-5">Show Lectures</p></a>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="xl:col-span-3 lg:col-span-3 col-span-12">
                        <!-- SIDE COURSES -->
                        @include('layout.side_courses')
                    </div>
                </div>
            </div>
        </div>
        @forelse($pages->page_details as $page)
            {!! $page->template !!}
        @empty
            <div class="alert alert-danger row">No Section Found!</div>
        @endforelse
    </section>
@endsection
@section('custum_js')
    {{--    <script src="/assets/frontend/js/bootstrap.bundle.min.js"></script>--}}
    <script>
        var acc = document.getElementsByClassName("accordionCur");
        var i;

        for (i = 0; i < acc.length; i++) {
            acc[i].addEventListener("click", function() {
                this.classList.toggle("active");
                var accordionCur_panel = this.nextElementSibling;
                if (accordionCur_panel.style.maxHeight) {
                    accordionCur_panel.style.maxHeight = null;
                } else {
                    accordionCur_panel.style.maxHeight = accordionCur_panel.scrollHeight + "px";
                }
            });
        }
    </script>
@endsection
