@extends('layout.master')
@section('page_title')
    Discipline
@endsection
@section('main_content')
    <div class="heightHead"></div>
    <section class="">
        <div class="btnback">
            <div class="xl:container lg:container md:container sm:container mb-4">
                <h1 class="text-2xl font-semibold text-white uppercase text-right xl:px-0 px-4">Discipline</h1>
            </div>
        </div>
        <div>
            <!-- SEARCH -->
            @include('layout.search')
        </div>
        <div class="container-fluid">
            <div class="xl:container lg:container md:container sm:container">
                <div class="grid grid-cols-12 gap-6 xl:my-12 lg:my-8 my-6 xl:px-0 px-4">
                    <div class="xl:col-span-9 lg:col-span-9 col-span-12">
                        <div class="w-full">
                            @foreach($courses as $key => $row)
                                <div class="mb-3">
                                    <button class="accordionDis text-base">{{ $row->title }}</button>
                                    <div class="accordionDis_panel">
                                        @if(!$row->children->isEmpty())
                                            @foreach($row->children as $child_key => $child)
                                                @if(!$child->children->isEmpty())
                                                    <a href="/course_categories/{{ $child->id }}"><p class="p-5">{{ $child->title }}</p></a>
                                                @else
                                                    <a href="/lecture/{{ $child->id }}"><p class="p-5">{{ $child->title }}</p></a>
                                                @endif
                                            @endforeach
                                        @else
                                            <a href="/lecture/{{ $row->id }}"><p class="p-5">Show Lectures</p></a>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="xl:col-span-3 lg:col-span-3 col-span-12">
                        <div class="sideCourse">
                            <h3 class="btnback text-white text-center text-xl py-1 font-medium">Basic and Health Sciences</h3>
                            <ul>
                                <li>Biology</li>
                                <li>Chemistry</li>
                                <li>Matha</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @forelse($pages->page_details as $page)
            {!! $page->template !!}
        @empty
            <div class="alert alert-danger row">No Section Found!</div>
        @endforelse
    </section>
@endsection
@section('custum_js')
    {{--    <script src="/assets/frontend/js/bootstrap.bundle.min.js"></script>--}}
    <script>
        var acc = document.getElementsByClassName("accordionDis");
        var i;

        for (i = 0; i < acc.length; i++) {
            acc[i].addEventListener("click", function() {
                this.classList.toggle("active");
                var accordionDis_panel = this.nextElementSibling;
                if (accordionDis_panel.style.maxHeight) {
                    accordionDis_panel.style.maxHeight = null;
                } else {
                    accordionDis_panel.style.maxHeight = accordionDis_panel.scrollHeight + "px";
                }
            });
        }
    </script>
@endsection
