@extends('layout.master')
@section('page_title')
Home tsets
@endsection

@section('main_content')
    <!-- SLIDER SECTION -->
    @isset ($banners)
        <section class="slider">
            <div class="heightHead"></div>
            <div class="w-full mx-auto">
                <div class="swiper-container" id="bannerSlider">
                    <div class="swiper-wrapper">
                        @foreach($banners[0]->banner_details as $key => $row)
                            @php if($key == "0"){
                                $d = "";
                                $c = "";
                                } else{
                                $d="data-";
                                $c="no-src lazyload";
                                }
                            @endphp
                            <div class="swiper-slide">
                                <div class="">
                                    <img  {{ $d }}src="/uploads{{$row->banner}}" class="img-fluid {{ $c }}  mx-auto" width="1903" height="880" alt="{{$row->title}}">
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <!-- Add Pagination -->
                    <div class="swiper-button-next banSlidBtn px-6 xs:px-3"></div>
                    <div class="swiper-button-prev banSlidBtn px-6 xs:px-3"></div>
                </div>

            </div>
        </section>
    @endisset
    <!-- KNOWLEDGE SECTION -->
    <section id="knowledge" class="pt-6 hidden">
        <div class="xl:container lg:container md:container sm:container">
            <div class="flex flex-wrap font-light sm:px-4 xs:px-4 relative">
                <div class="w-full mb-2">
                    <h3 class="text-xl text-primary md:mb-2 sm:mb-1 xs:mb-1 sm:mt-4 uppercase leading-7 text-right sm:text-center xs:text-center">FREE ONLINE Video LIBRARY  </h3>
                    <h1 class="text-center uppercase leading-tight contentGradient"><span class="font-light">lej</span> KNOWLEDGE HUB </h1>
                    <p class="text-xl sm:text-base xs:text-base text-center font-normal">“ Thousands of courses delivered by world authorities in Science, Engineering, Agriculture, Social Sciences,
                        Economics and other fields are  freely available at school, college and university levels. ” </p>
                    <div class="text-center w-full">
                        <a href="#" class="py-3 px-12 inline-block border mt-2 uppercase text-sm mt-4 btnBorder font-bold">Read More</a>
                    </div>
                    <div class="comstech sm:hidden xs:hidden">
                        <img data-src="assets/frontend/images/comstech-logo.png" class="img-fluid mx-auto no-src lazyload" alt="Comstech.png">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--  NEWS & WELCOM SECTION -->
    <section id="welcome" class="mt-6">
        <div class="container">
            <div class="flex flex-wrap">
                <div class="relative w-full">
                    <div class="w-full">
                        <marquee class="bg-primary_dark py-2 text-white text-center" behavior="" direction="">
                            @foreach($news as $row)
                                <span class="mx-32">{{$row->title}}</span> {{$row->content}}  <span class="text-sm text-gray-200 ml-2"> {{  $row->date ? ($row->date) : '' }} </span>
                            @endforeach
                        </marquee>
                    </div>
                    <div class="latestNews">
                        <p class="bg-black py-2 px-8 text-white text-centere">Latest News</p>
                    </div>
                </div>
            </div>
        </div>
        @forelse($pages->page_details as $page)
            {!! $page->template !!}
        @empty
            <div class="alert alert-danger row">No Section Found!</div>
        @endforelse
    </section>
    <!-- SEARCH SECTION -->
    <section id="search" class="pt-6">
        @include('layout.search')

    <!-- SEARCH COURSES -->
            @php
                function get_children_array($id,$arr) {
                    global $wpdb;
                    $result = \App\Category::where(['parent' => $id, 'status'=> 1 ])->get();
                    if($result) {
                        foreach ($result as $item) {
                            $arr[] = $item->id;
                            $children = \App\Category::where(['parent' => $item->id, 'status'=> 1 ])->count();
                            if($children > 0){
                                $arr = get_children_array($item->id,$arr);
                            }
                        }
                        return $arr;
                    } else {
                        return false;
                    }
                }
            @endphp
        <div class="pt-4" style="background: #f1f1f1">
            <div class="xl:container lg:container md:container sm:container">
                <div class="w-full xl:px-0 px-4">
                    <div class="tabset">
                        <!-- Tab 1 -->
                        @foreach($disciplines as $key => $row)
                            @php
                                $count = 0;
                                $count = \App\Lecture::select('id')->where(['discipline' => $row->id, 'status' => 1])->count();
                            @endphp
                            <input type="radio" name="tabset" id="tab{{ $key +1}}" aria-controls="{{ $key }}" checked>
                            <label for="tab{{ $key +1}}">{{ $row->title }} [{{ $row->count }}]</label>
                        @endforeach

                        <div class="tab-panels">
                            @foreach($disciplines as $key => $row)
                                <section id="{{ $key }}" class="tab-panel">
                                <div class="grid grid-cols-12 gap-6 md:gap-3 sm:gap-3 xs:gap-3 w-full pb-4">
                                    @foreach($row->disc as $course)
                                        <div class="col-span-3 md:col-span-6 sm:col-span-12 xs:col-span-12">
                                            <a href="/course_categories/{{ $course->id }}">
                                                <div class="bg-white py-2 text-center border border-gray-200 shadow hover:bg-black hover:text-white px-4">
                                                    <p class="text-xs">{{ $course->title }} [{{ $course->count }}]</p>
                                                </div>
                                            </a>
                                        </div>
                                    @endforeach
                            </section>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <!-- COURSES BY INSTITUTE -->
        <div class="">
            <div class="xl:container lg:container md:container sm:container">
                <div class="flex flex-wrap font-light sm:px-4 xs:px-4 relative my-3">
                    <div class="grid grid-cols-12 w-full sm:mt-4 xs:mt-4">
                        <div class="col-span-4 sm:col-span-2 xs:col-span-2 mb-2 ">
                            <img data-src="assets/frontend/images/right-arrow-vector.png" class="img-fluid ml-auto no-src lazyload" alt="Right Arrow">
                        </div>
                        <div class="col-span-4 sm:col-span-8 xs:col-span-8 mb-2">
                            <h1 class="text-center text-xl uppercase leading-tight contentGradient font-bold"> COURSES BY INSTITUTE </h1>
                        </div>
                        <div class="col-span-4 sm:col-span-2 xs:col-span-2 mb-2">
                            <img data-src="assets/frontend/images/left-arrow-vector.png" class="img-fluid mr-auto no-src lazyload" alt="Left Arrow">
                        </div>
                    </div>
                    <div class="w-full py-3">
                        <div class="grid grid-cols-12 gap-6 md:gap-3 sm:gap-3 xs:gap-3 w-full pb-4">
                            @foreach($institutes as $row)
                            <div class="col-span-3 md:col-span-6 md:col-span-6 sm:col-span-12 xs:col-span-12">
                                <a href="/search?title=&type=courses&discipline=0&level=0&institute={{ $row->id }}">
                                    <div class="bg-white py-2 text-center shadow hover:bg-black hover:text-white px-4">
                                        <p class="text-xs">{{ $row->title }}</p>
                                    </div>
                                </a>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <div class="collageSlider p-4" style="background: #343a40!important">
                <div class="xl:container lg:container md:container sm:container">
                    <div class="swiper-container" id="collageSlider" >
                        <div class="swiper-wrapper">
                            @foreach($institutes as $row)
                                @if($row->show_on_front == '1')
                                    <div class="swiper-slide">
                                        <div class="collageImg">
                                            <img data-src="/uploads{{ $row->image }}" class="img-fluid mx-auto no-src lazyload" alt="{{ $row->title }}">
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <!-- Add Pagination -->
{{--                            <div class="swiper-pagination"></div>--}}
                        <div class="swiper-button-next banSlidBtn px-6 xs:px-3"></div>
                        <div class="swiper-button-prev banSlidBtn px-6 xs:px-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- DETAIL SECTION -->
    <section id="detail" class="py-8">
        <div class="xl:container lg:container md:container sm:container sm:px-4">
            <div class="grid grid-cols-12 gap-6 w-full md:px-4 sm:px-4 xs:px-4 relative mb-2">
                <div class="col-span-4 md:col-span-6 sm:col-span-12 xs:col-span-12">
                    <div class="col-span-12 mb-4">
                        <h1 class="text-lg uppercase tracking-widest font-medium"> RECENT COURSES </h1>
                    </div>
                    @foreach($banners[1]->banner_details as $key => $row)
                    <div class="grid grid-cols-12 gap-3">
                        <div class="col-span-4">
                            <a href="{{$row->title}}">
                                <div class="recentImg">
                                    <img data-src="/uploads{{$row->banner}}" class="img-fluid mx-auto no-src lazyload" alt="PROF. DR. ATTA-UR-RAHMAN">
                                </div>
                            </a>
                        </div>
                        <div class="col-span-8 leading-5 my-auto">
                            <a href="{{$row->title}}">
                                <p class="text-sm mb-2">{{$row->title}}</p>
                                <a href="{{$row->title}}" class="text-base font-medium text-primary leading-3">{{$row->description}}</a>
                            </a>
                        </div>
                    </div>
                        <hr class="my-4">
                    @endforeach
                </div>
                <div class="col-span-4 md:col-span-6 sm:col-span-12 xs:col-span-12">
                    <div class="col-span-12 mb-4">
                        <h1 class="text-lg uppercase tracking-widest font-medium"> LOCATION </h1>
                    </div>
                    <div class="">
                        <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d231529.22506445748!2d67.124444!3d24.94419!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0xaa89ba5b41d984dd!2sLEJ%2C%20ICCBS!5e0!3m2!1sen!2sus!4v1627906932482!5m2!1sen!2sus" width="100%" height="350" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                    </div>
                </div>
                <div class="col-span-4 md:col-span-12 sm:col-span-12 xs:col-span-12">
                    <div class="col-span-12 mb-4">
                        <h1 class="text-lg uppercase tracking-widest font-medium"> YOUR COMMENTS </h1>
                    </div>
                    <div id="contact__register"></div>
                    <div class="col-span-12 mb-4">
                        <input type="text" name="" id="first_name" value="{{ old('first_name') }}" class="bg-transparent border border-gray-400 w-full p-2 placeholder-black" placeholder="Your Name">
                        <div class="text-left text-primary mx-auto w-full">
                            <span id="first_name_error" role="alert"></span>
                        </div>
                    </div>
                    <div class="col-span-12 mb-4">
                        <input type="email" name="" class="bg-transparent border border-gray-400 w-full p-2 placeholder-black" placeholder="Your Email" id="email" value="{{ old('email') }}">
                        <div class="text-left text-primary mx-auto w-full">
                            <span id="email_error" role="alert"></span>
                        </div>
                    </div>
                    <div class="col-span-12 mb-4">
                        <input type="phone" name="" class="bg-transparent border border-gray-400 w-full p-2 placeholder-black" placeholder="Your Phone" id="phone" value="{{ old('phone') }}">
                        <div class="text-left text-primary mx-auto w-full">
                            <span id="phone_error" role="alert"></span>
                        </div>
                    </div>
                    <div class="col-span-12 mb-4">
                        <textarea name="message" id="message" class="w-full bg-transparent border border-gray-400 w-full p-2 placeholder-black h-24 outline-none"  placeholder="Your Message" spellcheck="false"></textarea>
                    </div>
{{--                        <div class="col-span-12 mb-4">--}}
{{--                            <input type="text" name="" class="bg-transparent border border-gray-400 w-full p-2 placeholder-black" placeholder="Sum of 2+2">--}}
{{--                        </div>--}}
                        <button onclick="contactSubmit()" type="submit" class="focus:outline-none btnback rounded-md text-center py-2 text-white w-full">Send</button>
                </div>
            </div>
        </div>
    </section>
    <!-- CONTACT SECTION -->
@endsection

