<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="keywords" content="fullscreen image, grid layout, flexbox grid, transition" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots" content="noindex, nofollow" />
        <?php if(isset($banners)): ?>
            <link rel="preload" as="image" href="/uploads<?php echo e($banners[0]->banner_details[0]->banner); ?>" />
        <?php endif; ?>
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title>
            <?php echo $__env->yieldContent('page_title'); ?> | LEJ Knowledge Hub

        </title>
        <meta name="keywords" content="<?php echo e($pages->meta_keyword); ?>">
        <meta name="description" content="<?php echo e($pages->meta_description); ?>">
        <meta property="og:image" content="<?php echo e(($pages->meta_image) ? url('/uploads'.$pages->meta_image) : '/assets_front/images/fav-icon.png'); ?>">
        <meta property="og:image:type" content="image/png/jpg/jpeg/JPG/JPEG">
        <meta property="og:image:height" content="200">
        <meta property="og:image:width" content="200">
        <meta property="og:title" content="<?php echo e(($pages->meta_image) ? $pages->meta_title : $settings->site_title); ?>">
        <meta property="og:description" content="<?php echo e($pages->meta_description); ?>">
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?php echo e(\Request::url()); ?>" />
        <meta property="fb:app_id" content="941016295913919" />



        <link rel="icon" type="image/png" href="/assets/frontend/images/fav-icon.png"/>
        <!-- Fonts -->

        
        <link rel="preconnect" href="https://fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Fjalla+One&family=Montserrat:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
        
    <!-- Bootstrap CSS -->
        <?php echo $__env->yieldContent('custum_css'); ?>

        <!-- FontOwesome -->
         <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.2/css/all.css" integrity="sha384-vSIIfh2YWi9wW0r9iZe7RJPrKwp6bG+s9QZMoITbCckVJqGCCRhc+ccxNcdpHuYu" crossorigin="anonymous">

        <!-- Swiper Slider -->
        <link rel="stylesheet" href="/assets/frontend/css/swiper-bundle.min.css">

        <!-- Styles -->
        <link rel="stylesheet" href="<?php echo e(mix('/css/app.css')); ?>">
        <link rel="stylesheet" href="/assets/frontend/css/style.css">
        <link rel="stylesheet" href="/assets/frontend/css/fancybox.css"/>
        <link rel="stylesheet" href="/assets/frontend/css/mimsoft.css"/>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="/assets/frontend/js/fancybox.min.js"></script>



    </head>
    <body>





        <header class="headBack__img" >

                <div class="xl:container lg:container md:container siteNav sm:w-full xs:w-full">
                    <div class="flex flex-wrap xl:px-0 px-4">
                        <div class="w-1/4 sm:w-1/2 xs:w-1/2 my-auto">
                            <a href="/">
                                    <img src="/assets/frontend/images/logo.svg" class="logo-img img-fluid" alt="LEJ Knowledge Hub" width="215" height="150">
                            </a>
                        </div>
                        <div class="w-3/4 sm:w-1/2 xs:w-1/2 my-auto">
                            <div class="w-full">
                                <!-- MOBILE SECTION -->
                                <div class="xl:hidden lg:hidden float-right">
                                    <ul class="">
                                    <li class="my-auto">
                                        <a href="#" class="uppercase sm:ml-4 xs:ml-0 flex flex-wrap">
                                            <div class="flex flex-wrap hamburger" id="hamburger">
                                                <div class="w-1/2 hamburger" >
                                                    <span class="span-1"></span>
                                                    <span class="span-2"></span>
                                                    <span class="span-3"></span>
                                                </div>
                                                <div class="w-1/2 my-auto sm:hidden xs:hidden ">
                                                    <p>Menu</p>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
    
    
    
    
    
                                    <li class="my-auto md:hidden sm:hidden xs:hidden lg:hidden" style="--i:5;"><a href="#" class="uppercase sm:ml-3 xs:ml-0 text-xl"> |</a></li>
                                    <li class="sm:hidden xs:hidden lg:hidden my-auto md:hidden" style="--i:6;"><a href="tel:92111111467" class="text-right uppercase sm:ml-0 xs:ml-0"> <i class="fas fa-phone-alt phoneIcon"></i> <?php echo e($settings->phone); ?> </a></li>
                                </ul>
                                </div>
                                <!-- DESKTOP SECTION -->
                                <div class="md:hidden sm:hidden xs:hidden float-right">
                                    <ul class="list-inline text-2xl uppercase text-white font-normal text-center">
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a href="/" class="<?php echo e(Request::is('/') ? 'active' : null); ?>">Home</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a>|</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a href="<?php echo e(route('about')); ?>" class="<?php echo e(Request::is('about') ? 'active' : null); ?>" >About US</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a>|</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a href="<?php echo e(route('creditors')); ?>" class="<?php echo e(Request::is('creditors') ? 'active' : null); ?>">Creditors</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a>|</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a href="<?php echo e(route('mentorship')); ?>" class="<?php echo e(Request::is('mentorship') ? 'active' : null); ?>">Mentorship</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a>|</a>
                                        </li>
                                        <li class="list-inline-item mb-1 hover:text-secondary">
                                            <a href="<?php echo e(route('faqs')); ?>" class="<?php echo e(Request::is('faqs') ? 'active' : null); ?>">Faq</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

        </header>
            <div class="" id="sidebare">
                <ul class="list-inline text-2xl uppercase text-white font-normal text-center">
                    <li class="list-inline-item mb-3 hover:text-secondary">
                        <a href="/" class="<?php echo e(Request::is('/') ? 'active' : null); ?>">Home</a>
                    </li>
                    <li class="list-inline-item mb-3 hover:text-secondary">
                        <a href="<?php echo e(route('about')); ?>" class="<?php echo e(Request::is('about') ? 'active' : null); ?>" >About US</a>
                    </li>
                    <li class="list-inline-item mb-3 hover:text-secondary">
                        <a href="<?php echo e(route('creditors')); ?>" class="<?php echo e(Request::is('creditors') ? 'active' : null); ?>">Creditors</a>
                    </li>
                    <li class="list-inline-item mb-3 hover:text-secondary">
                        <a href="<?php echo e(route('mentorship')); ?>" class="<?php echo e(Request::is('mentorship') ? 'active' : null); ?>">Mentorship</a>
                    </li>
                    <li class="list-inline-item mb-3 hover:text-secondary">
                        <a href="<?php echo e(route('faqs')); ?>" class="<?php echo e(Request::is('faqs') ? 'active' : null); ?>">Faq</a>
                    </li>
                </ul>
            </div>

    <!-- BEGIN MAIN CONTENT -->
        <?php echo $__env->yieldContent('main_content'); ?>
    <!-- END MAIN CONTENT -->

        <!-- FOOTER SECTION -->
        <section id="footer">
            <div class="sm:mt-6 xs:mt-6" style="background: #343a40!important">
                <div class="xl:container lg:container md:container sm:container py-8 footerRing">

                    <a href="/">
                        <img data-src="/assets/frontend/images/footer-logo.svg" class="logo-img mx-auto no-src lazyload" width="320" height="64" alt="LEJ Knowledge Hub">
                    </a>
                    <div class="w-full text-center my-4">
                        <ul class="text-white inline-block w-full">
                            <li class="mr-6 inline-block ">
                                <div class="flex items-center text-center justify-center">
                                    <a href="http://<?php echo e($settings->facebook); ?>">
                                        <i class="fab fa-facebook-f text-white text-xl"></i>
                                    </a>
                                </div>
                            </li>
                            <li class="mr-6 inline-block ">
                                <div class="flex items-center text-center justify-center">
                                    <a href="http://<?php echo e($settings->linkedin); ?>">
                                        <i class="fab fa-linkedin-in text-white text-xl"></i>
                                    </a>
                                </div>
                            </li>
                            <li class="inline-block ">
                                <div class="flex text-center justify-center">
                                    <a href="http://<?php echo e($settings->instagram); ?>">
                                        <i class="fab fa-instagram text-white text-xl"></i>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="w-full sm:w-full xs:w-full">
                        <div class="flex flex-wrap justify-center mimDetail">
                            <p class="text-white text-right sm:text-center xs:text-center xs:text-md pr-2 text-sm"><?php echo e($settings->copyright); ?></p>
                            <div class="flex sm:justify-center xs:justify-center xs:text-md pl-2">
                                <p class="text-white mr-2 text-sm">Powered By: </p>
                                <a href="https://www.mim-soft.com/" target="_blank">
                                    <img src="/assets/frontend/images/mim-logo.svg" class="img-fluid" width="100" height="25" alt="Mimsoft">
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--AOS Animation -->

        <link rel="stylesheet" href="/assets/frontend/css/aos.css" />

        <script src="/assets/frontend/js/swiper-bundle.min.js"></script>
        <script src="/assets/frontend/js/theme.js"></script>
    <!-- Bootstrap Bundle) -->
        <?php echo $__env->yieldContent('custum_js'); ?>
        <script src="/assets/frontend/js/lazysizes.min.js"></script>
        <script src="/assets/frontend/js/jquery.event.move.js"></script>
        <script src="/assets/frontend/js/mimsoft.js"></script>
        <script type="text/javascript" src="/assets/frontend/js/vanilla-tilt.min.js"></script>
        <script src="/assets/frontend/js/aos.js"></script> <!--Scrol Animation -->

        <script>
            AOS.init({once: true}); //* Scrol Animation *//
        </script>
        <script>
            // ******** Preloader ******** //
            window.addEventListener('load', () => {
                const preloader = document.querySelector(".preloader");
                preloader.classList.add("preload-finish")
            });

        </script>






















        <script type="text/javascript">
            VanillaTilt.init(document.querySelector(".vanilaJs"), {
                max: 25,
                speed: 400
            });

        </script>
<script>
    /* Optional Javascript to close the radio button version by clicking it again */
    var myRadios = document.getElementsByName('tabs2');
    var setCheck;
    var x = 0;
    for(x = 0; x < myRadios.length; x++){
        myRadios[x].onclick = function(){
            if(setCheck != this){
                setCheck = this;
            }else{
                this.checked = false;
                setCheck = null;
            }
        };
    }
</script>
        <script type="text/javascript">
            const hamburger = document.getElementById('hamburger');
            const sidebare = document.getElementById('sidebare');
            document.onclick = function(e) {
                if(e.target.id !== 'sidebare' && e.target.id !== 'hamburger')
                {
                    hamburger.classList.remove('active');
                    sidebare.classList.remove('active');
                }
            }
            hamburger.onclick = function(){
            hamburger.classList.toggle('active');
            sidebare.classList.toggle('active');
            }
        </script>
        <script>
            var videoPlayer = document.getElementById('videoPlayer');
            var hmrVideo = document.getElementById('hmrVideo');
            function stopVideo() {
                videoPlayer.style.display = "none";
            }
            function playVideo(file) {
                hmrVideo.src = file;
                videoPlayer.style.display = "block";
            }
        </script>
        <script>
            $("#playvideo").click(function(){
                $("#video1")[0].src += "?autoplay=1";
            });
        </script>
        <script>
            var openmodal = document.querySelectorAll('.modal-open')
            for (var i = 0; i < openmodal.length; i++) {
                openmodal[i].addEventListener('click', function(event){
                    event.preventDefault()
                    toggleModal()
                })
            }

            const overlay = document.querySelector('.modal-overlay')
            overlay.addEventListener('click', toggleModal)

            var closemodal = document.querySelectorAll('.modal-close')
            for (var i = 0; i < closemodal.length; i++) {
                closemodal[i].addEventListener('click', toggleModal)
            }

            document.onkeydown = function(evt) {
                evt = evt || window.event
                var isEscape = false
                if ("key" in evt) {
                    isEscape = (evt.key === "Escape" || evt.key === "Esc")
                } else {
                    isEscape = (evt.keyCode === 27)
                }
                if (isEscape && document.body.classList.contains('modal-active')) {
                    toggleModal()
                }
            };


            function toggleModal () {
                const body = document.querySelector('body')
                const modal = document.querySelector('.modal')
                modal.classList.toggle('opacity-0')
                modal.classList.toggle('pointer-events-none')
                body.classList.toggle('modal-active')
            }


        </script>


    </body>
</html>
<?php /**PATH /home/lej4learning/public_html/resources/views/layout/master.blade.php ENDPATH**/ ?>