<div class="xl:container lg:container md:container sm:container">
    <div class="grid grid-cols-12 font-light sm:px-4 xs:px-4 relative mb-2">
        <div class="col-span-4 sm:col-span-2 xs:col-span-2 mb-2 ">
            <img data-src="/assets/frontend/images/right-arrow-vector.png" class="img-fluid ml-auto no-src lazyload" alt="Right Arrow">
        </div>
        <div class="col-span-4 sm:col-span-8 xs:col-span-8 mb-2">
            <h1 class="text-center text-xl uppercase leading-tight contentGradient font-bold"> SEARCH COURSES / LECTURES </h1>
        </div>
        <div class="col-span-4 sm:col-span-2 xs:col-span-2 mb-2">
            <img data-src="/assets/frontend/images/left-arrow-vector.png" class="img-fluid mr-auto no-src lazyload" alt="Left Arrow">
        </div>
    </div>
</div>
<div class="bg-primary_dark py-2 xl:px-0 px-4">
    <div class="xl:container lg:container md:container sm:container">
        <form name="searchForm" method="GET" action="<?php echo e(route('search')); ?>">
            <div class="grid grid-cols-12 gap-6 sm:gap-3 xs:gap-3 w-full">
                <div class="col-span-3 sm:col-span-12 xs:col-span-12">
                    <input type="search" name="title" class="text-xs text-white bg-transparent rounded-md border-white py-2 px-2 my-1 w-full border border-white placeholder-white" value="<?php echo e(request('title') ?? ''); ?>" placeholder="Enter Your Keyword...">
                </div>
                <div class="col-span-2 sm:col-span-12 xs:col-span-12 flex flex-wrap">
                    <div class="grid grid-cols-12 gap-1 w-full border border-white my-auto">
                        <div class="col-span-2 m-auto">
                            <i class="fas fa-th-large text-white"></i>
                        </div>
                        <div class="col-span-10">
                            <select name="type" class="form-select block text-xs text-white bg-transparent border-white py-1 my-1 w-full placeholder-white auto outline-none">
                                <option value="lectures" class="text-black" <?php echo e(request('type') == 'lectures' ? 'Selected' : null); ?>>Search Lectures</option>
                                <option value="courses" class="text-black py-2" <?php echo e(request('type') == 'courses' ? 'Selected' : null); ?>>Search Courses</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-span-2 sm:col-span-12 xs:col-span-12 flex flex-wrap">
                    <div class="grid grid-cols-12 gap-1 w-full border border-white my-auto">
                        <div class="col-span-2 m-auto">
                            <i class="fas fa-th-large text-white"></i>
                        </div>
                        <div class="col-span-10">
                            <select name="discipline" class="form-select block text-xs text-white bg-transparent border-white py-1 my-1 w-full placeholder-white auto outline-none">
                                <option value="0" class="text-black">All Disciplines</option>
                                <?php if(isset($disciplines)): ?>
                                    <?php $__currentLoopData = $disciplines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($row->id); ?>" class="text-black py-2" <?php echo e(request('discipline') == $row->id ? 'Selected' : null); ?>><?php echo e($row->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-span-2 sm:col-span-12 xs:col-span-12 flex flex-wrap">
                    <div class="grid grid-cols-12 gap-1 w-full border border-white my-auto">
                        <div class="col-span-2 m-auto">
                            <i class="fas fa-th-large text-white"></i>
                        </div>
                        <div class="col-span-10">
                            <select name="level" class="form-select block text-xs text-white bg-transparent border-white py-1 my-1 w-full placeholder-white auto outline-none">
                                <option value="0" class="text-black">All Levels</option>
                                <?php if(isset($levels)): ?>
                                    <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($row->id); ?>" class="text-black py-2" <?php echo e(request('level') == $row->id ? 'Selected' : null); ?>><?php echo e($row->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-span-2 sm:col-span-12 xs:col-span-12 flex flex-wrap">
                    <div class="grid grid-cols-12 gap-1 w-full border border-white my-auto">
                        <div class="col-span-2 m-auto">
                            <i class="fas fa-th-large text-white"></i>
                        </div>
                        <div class="col-span-10">
                            <select name="institute" class="form-select block text-xs text-white bg-transparent border-white py-1 my-1 w-full placeholder-white auto outline-none">
                                <option value="0" class="text-black">All Institutes</option>
                                <?php if(isset($institutes)): ?>
                                    <?php $__currentLoopData = $institutes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($row->id); ?>" class="text-black py-2" <?php echo e(request('institute') == $row->id ? 'Selected' : null); ?>><?php echo e($row->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-span-1 sm:col-span-12 xs:col-span-12 my-auto">
                    <button type="submit" class="w-full bg-gray-100 text-center item-center py-1 focus:outline-none">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php /**PATH /home/lej4learning/public_html/resources/views/layout/search.blade.php ENDPATH**/ ?>